# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        管理网口连接状态检查：
        1 ETH port中type为Management Port的Health Status必须为Normal。
                        端口Running Status为Link Up且工作速率为100Mbps或1000Mbps时表示正常；
        2 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show port general physical_type=ETH logic_type=Management_Port"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.management.port.info")
            LOGGER.logNoPass("Cannot get information about Management Port")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            portId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            workingRate = line.get("Working Rate(Mbps)")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "management.port.health.status.abnormal",(portId, healthStatus))
                LOGGER.logNoPass("The Health Status of management port [%s] is abnormal (Health Status:%s)" 
                     % (portId, healthStatus))
            
            if runningStatus == common.STATUS_LINK_UP and workingRate not in ["100" , "1000"]:
                flag = False
                errMsg += common.getMsg(LANG, "management.port.working.rate.abnormal", 
                    (portId, workingRate))
                LOGGER.logNoPass("The working rate of management port [%s] is abnormal (Working Rate:%sMbps)" 
                     % (portId, workingRate))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
