# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    PCIe端口状态检查：
        1 如果PCIe端口不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    portName = "PCIe"
    
    try:
        cmd = "show port general physical_type=PCIE"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.port.info", portName)
            LOGGER.logNoPass("Cannot get information about PCIe port")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            portId = line.get("ID")
            healthStatus = line.get("Health Status")
                
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.health.status.abnormal", (portName, portId, healthStatus))
                LOGGER.logNoPass("The Health Status of PCIe port [%s] is abnormal (Health Status:%s)" 
                     % (portId, healthStatus))
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
                                  
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
