# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        电源状态检查：
        Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show power_supply"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.power.supply.info")
            LOGGER.logNoPass("Cannot get information about power supply")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            power_id = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.health.status.abnormal", (power_id, healthStatus))
                LOGGER.logNoPass("The Health Status of power supply [%s] is abnormal (Health Status:%s)" % 
                    (power_id, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.running.status.abnormal", (power_id, runningStatus))
                LOGGER.logNoPass("The Running Status of power supply [%s] is abnormal (Running Status:%s)" % 
                    (power_id, runningStatus))
        
        if flag:
            LOGGER.logPass()

        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
