# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.cli import cliUtil as cbbCliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        一致性组状态检查：
        1 如果一致性组不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show consistency_group general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cbbCliUtil.getHorizontalNostandardCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.consistency.group.info")
            LOGGER.logNoPass("Cannot get information about consistency group")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line.get("ID")
            healthStatus = line.get("Health Status")
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "consistency.group.health.status.abnormal", (Id, healthStatus))
                LOGGER.logNoPass("The Health Status of consistency group [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
