# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        卷镜像状态检查： 
        1 如果卷镜像不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show mirror_lun general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        # 校验是否包含错误码，如果包含则不涉及
        if cliUtil.has_unknown_error(cliRet):
            return cliUtil.RESULT_NOSUPPORT, cliRet, cliUtil.getMsg(LANG, "has.not.license")

        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet

        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.mirror.lun.info")
            LOGGER.logNoPass("Cannot get information about mirror LUN")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line.get("ID")
            healthStatus = line.get("Health Status")
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "mirror.lun.health.status.abnormal", (Id, healthStatus))
                LOGGER.logNoPass("The Health Status of mirror LUN [%s] is abnormal (Health Status:%s)" 
                     % (Id, healthStatus))
        
        if flag:
            LOGGER.logPass()

        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
