# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        是否有临时license检查：
        1 如果license不存在表示正常；
        2 LICENSE SERVICE AUTH TYPE为DEMO表示不正常，否则表示正常。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show license"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLines = cliRet.splitlines()
        for line in cliRetLines:
            line = line.strip()
            if not line.startswith("Left Day(s)"):
                continue
            
            leftDaysList = line.split(":")
            if len(leftDaysList) != 2:
                errMsg = common.getMsg(LANG, "cannot.get.license.service.auth.info")
                LOGGER.logNoPass("Cannot get information about LICENSE SERVICE AUTH TYPE")
                return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
            
            leftDays = leftDaysList[1].strip()
            LOGGER.logNoPass("leftDays:%s" % leftDays)
            if int(leftDays) < 1825:
                errMsg = common.getMsg(LANG, "system.exists.temporary.license")
                LOGGER.logNoPass("LICENSE SERVICE AUTH TYPE is DEMO, a temporary license exists")
                return (False, cliRet, errMsg)
            
        return (True, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
