# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        远端设备链路状态检查：
        1 如果远端设备链路不存在表示正常；
        2 Health Status为Normal表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show remote_device link"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        linkNameList = ["FC", "ISCSI"]
        for linkName in linkNameList:
            linkRet = cliUtil.getSplitedCliRet(cliRet, linkName + " Link:")
            if len(linkRet) == 0:
                continue
            
            cliRetLinesList = cliUtil.getHorizontalCliRet(linkRet)
            if len(cliRetLinesList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.link.info", linkName)
                LOGGER.logNoPass("Cannot get information about %s Link" % linkName)
                continue
            
            for line in cliRetLinesList:
                Id = line.get("ID")
                healthStatus = line.get("Health Status")
                if healthStatus != common.STATUS_NORMAL:
                    flag = False
                    if cliUtil.isChinese(LANG):
                        errMsg += u"\n%s链路中远端设备链路[%s]健康状态异常(健康状态：%s)" % (linkName, Id, healthStatus)
                    else:    
                        errMsg += "\nThe Health Status of remote device link [%s] in %s link is abnormal (Health Status:%s)" % \
                            (Id, linkName, healthStatus)
                    LOGGER.logNoPass("The Health Status of remote device link [%s] in %s link is abnormal (Health Status:%s)" % 
                            (Id, linkName, healthStatus))
        
        if flag:
            LOGGER.logPass()  
                    
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
