# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        设备序列号: 
                序列号（SN）存在且符合要求表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show system general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.device.sn.info")
            LOGGER.logNoPass("Cannot get information about serial number of device")
            return (False, cliRet, errMsg)
        
        retDict = cliRetLinesList[0]
        sn = retDict.get("SN")
            
        if len(sn) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.device.sn.info")
            LOGGER.logNoPass("Cannot get information about serial number of device")
            return (False, cliRet, errMsg)
        
        elif len(sn) != common.SERIAL_NUMBER_LENGTH:
            errMsg = common.getMsg(LANG, "device.sn.incorrect")
            LOGGER.logNoPass("The serial number information of device is incorrect")
            return (False, cliRet, errMsg)
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
