# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    Hotspare容量检查: 
        1 如果硬盘域不存在表示正常；
        2 Used Hot Spare Capacity值0表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk_domain general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.disk.domain.info")
            LOGGER.logNoPass("Cannot get information about disk domain")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            Id = line.get("ID")
            usedHotSpareCapacity = line.get("Used Hot Spare Capacity")
            realUsedHotSpareCapacity = common.getRealCapacity(usedHotSpareCapacity)
            if len(realUsedHotSpareCapacity) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.used.hot.spare.capacity.info", Id)
                LOGGER.logNoPass("Cannot get information about Used Hot Spare Capacity of POOL [%s]" % Id)
            elif not float(realUsedHotSpareCapacity) == float(0):
                flag = False
                errMsg += common.getMsg(LANG, "pool.used.hot.spare.capacity.abnormal", (Id, usedHotSpareCapacity))
                LOGGER.logNoPass("The Used Hot Spare Capacity of POOL [%s] is more than 0 (Capacity:%s)" 
                     % (Id, usedHotSpareCapacity))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))

