# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    LUN状态检查: 
                如果不存在相应的记录表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = 'show lun general |filterRow column=Running\sStatus predict=not predict2=equal_to value=Running\sSuccess logicOp=and column=Running\sStatus predict=not predict2=equal_to value=Running\sNormal logicOp=and column=Running\sStatus predict=not predict2=equal_to value=Online logicOp=or column=Health\sStatus predict=not predict2=equal_to value=Normal'
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.lun.info")
            LOGGER.logNoPass("Cannot get information about LUN")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            flag = False
            lunId = line.get("ID")
            errMsg += common.getMsg(LANG, "lun.status.abnormal", lunId)
            LOGGER.logNoPass("The status of LUN [%s] is abnormal" % lunId)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
