# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    LUN归属检查: 
                如果不存在相应的记录表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True:
            LOGGER.logNoPass("Cannot get information about controllers")
            return checkRet
            
        controllerList = checkRet[1]
        cmdList = []
        lunOwnerCmd = "show lun general|filterRow column=Work\sController predict=equal_to value=-- logicOp=or column=Owner\sController predict=equal_to value=--"
        cmdList.append(lunOwnerCmd)
        
        for ctrlId in controllerList:
            cmd = "show lun general|filterRow column=Work\sController predict=equal_to value=%s logicOp=and column=Owner\sController predict=not predict2=equal_to value=%s" % (ctrlId, ctrlId)
            cmdList.append(cmd)
        
        for cmd in cmdList:
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRetAll += checkRet[1]
            if checkRet[0] != True:
                errMsg += checkRet[2]
                LOGGER.logSysAbnormal()
                return (checkRet[0], cliRetAll, errMsg)
            
            cliRet = checkRet[1]
            if cliUtil.queryResultWithNoRecord(cliRet):
                continue
        
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            if len(cliRetLinesList) == 0:
                errMsg += common.getMsg(LANG, "cannot.get.lun.ownership.info")
                LOGGER.logNoPass("Cannto get information about LUN ownership")
                return (False, cliRetAll, errMsg)
            
            for line in cliRetLinesList:
                flag = False
                lunID = line.get("ID")
                if cmd == lunOwnerCmd:
                    errMsg += common.getMsg(LANG, "lun.controller.owner.invalid", lunID)
                    LOGGER.logNoPass("The work controller or owner controller of LUN [%s] is invalid" % lunID)
                else:    
                    errMsg += common.getMsg(LANG, "lun.controller.owner.inconsistent", lunID)
                    LOGGER.logNoPass("The work controller of LUN [%s] is not consistent with owner controller" % lunID)
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
    
