# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    LUN写策略: 
                如果不存在相应的记录表示正常，否则属于不正常状态。
    '''
    flag = True
    cliRet = ""
    cliRetAll = ""
    errMsg = ""

    try:
        writePolicyList = ["Write Back", "Write Through", "Write Back Mandatory"]
        for writePolicy in writePolicyList:
            writePolicyFilter = writePolicy.strip().replace(" ", "\s")
            cmd = "show lun general|filterRow column=Write\sPolicy predict=equal_to value=%s logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=%s" % (writePolicyFilter, writePolicyFilter)
            LOGGER.logExecCmd(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRetAll += checkRet[1]
            if checkRet[0] != True: 
                errMsg += checkRet[2]
                LOGGER.logSysAbnormal()
                return (False, cliRetAll, errMsg)
            
            cliRet = checkRet[1]
            if cliUtil.queryResultWithNoRecord(cliRet):
                continue
            
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            if len(cliRetLinesList) == 0:
                errMsg += common.getMsg(LANG, "cannot.get.lun.write.policy.info")
                LOGGER.logNoPass("Cannot get information about LUN write policy")
                return (False, cliRetAll, errMsg)
            
            for line in cliRetLinesList:
                flag = False
                lunID = line.get("ID")
                errMsg += common.getMsg(LANG, "lun.write.policy.inconsistent", lunID)
                LOGGER.logNoPass("The write policy of LUN [%s] is not consistent with running write policy" % lunID)
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
