# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    POOL状态检查: 
        1 如果POOL不存在表示正常；
        2 Health Status为Normal且Running Status为Online或Balancing表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            poolId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "pool.health.status.abnormal", (poolId, healthStatus))
                LOGGER.logNoPass("The Health Status of POOL [%s] is abnormal (Health Status:%s)" % 
                    (poolId, healthStatus))
            
            if runningStatus not in [common.STATUS_ONLINE, common.STATUS_BALANCING]:
                flag = False
                errMsg += common.getMsg(LANG, "pool.running.status.abnormal", (poolId, runningStatus))
                LOGGER.logNoPass("The Running Status of POOL [%s] is abnormal (Running Status:%s)" % 
                    (poolId, runningStatus))
                
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))

