# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    RAID配置检查: 
        1 容量层配置的RAID级别为RAID0、RAID3、RAID5、RAID50表示不正常；
        2 除容量层外的其他层配置的RAID级别为RAID0表示不正常；
        3 其他情况均属于正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show storage_pool general"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (False, cliRet, errMsg)
        
        for line in cliRetLinesList:
            poolId = line.get("ID")
            cmd_tier = "show storage_pool tier pool_id=%s" % poolId
            LOGGER.logExecCmd(cmd_tier)
            checkRetTier = cliUtil.excuteCmdInCliMode(cli, cmd_tier, True, LANG)
            cliRet += checkRetTier[1]
            if checkRetTier[0] != True: 
                errMsg += checkRetTier[2]
                LOGGER.logSysAbnormal()
                return (checkRetTier[0], cliRet, errMsg)
            
            cliRetTier = checkRetTier[1]
            tierList = cliUtil.getVerticalCliRet(cliRetTier)
            if len(tierList) == 0:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.tier.info")
                LOGGER.logNoPass("Cannot get information about Tier")
            
            for retDict in tierList:
                tierName = retDict.get("Name")
                raidLevel = retDict.get("RAID Level")
                if tierName.lower() == "capacity":
                    if raidLevel in ["RAID0", "RAID3", "RAID5", "RAID50"]:
                        flag = False
                        errMsg += common.getMsg(LANG,"raid.level.improperly.config", (poolId, tierName, raidLevel))
                        LOGGER.logNoPass("The RAID level of %s layer in POOL [%s] is improperly configured (RAID Level:%s)" % 
                             (tierName, poolId, raidLevel))
                else:
                    if raidLevel in ["RAID0"]:
                        flag = False
                        errMsg += common.getMsg(LANG,"raid.level.improperly.config", (poolId, tierName, raidLevel))
                        LOGGER.logNoPass("The RAID level of %s layer in POOL [%s] is improperly configured (RAID Level:%s)" % 
                             (tierName, poolId, raidLevel))

        if flag:
            LOGGER.logPass()
               
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
