# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BBU版本检查: 
                所有BBU的Firmware Version均存在且一致表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        bbuRet = cliUtil.getSplitedCliRet(cliRet, "BBU:")
        cliRetLinesList = cliUtil.getHorizontalCliRet(bbuRet)
        
        if len(bbuRet) == 0 or len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.firmware.version.info")
            LOGGER.logNoPass("Cannot get information about Firmware Version of BBU")
            return (False, cliRet, errMsg)
        
        bbuVersionSet = set()
        for line in cliRetLinesList:
            bbuId = line.get("ID")
            bbuVersion = line.get("Firmware Version")
            if len(bbuVersion) > 0 and bbuVersion != "--":
                bbuVersionSet.add(bbuVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.firmware.version.of.bbu", bbuId)
                LOGGER.logNoPass("Cannot get information about Firmware Version of BBU [%s]" % bbuId)
        
        if len(bbuVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "firmware.version.of.bbu.inconsistent", ", ".join(bbuVersionSet))
            LOGGER.logNoPass("The firmware versions of all BBUs are inconsistent")
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
