# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        逻辑版本检查: 
        1 所有控制器的Logic Version一致表示正常；
        2 硬盘框或高密框的所有级联模块的Logic Version均存在且分别一致表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    versionName = "Logic"
    
    try:
        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        controllerRet = cliUtil.getSplitedCliRet(cliRet, "Controller:")
        cliRetLinesList = cliUtil.getVerticalCliRet(controllerRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.version.of.controller")
            LOGGER.logNoPass("Cannot get information about version of controllers")
            return (False, cliRet, errMsg)
        
        logicVersionSet = set()
        for retDict in cliRetLinesList:
            controllerId = retDict.get("Controller")
            logicVersion = retDict.get("Logic Version")
            if len(logicVersion) > 0 and logicVersion != "--":
                logicVersionSet.add(logicVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.logic.version.of.controller", controllerId)
                LOGGER.logNoPass("Cannot get information about logic version of controller [%s]" % controllerId)
    
        if len(logicVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.controller.inconsistent", (versionName, ", ".join(logicVersionSet)))
            LOGGER.logNoPass("The logic versions of all controllers are inconsistent")
        
        expModuleRet = cliUtil.getSplitedCliRet(cliRet, "Expansion Module:")
        if len(expModuleRet) == 0:
            return (True, cliRet, errMsg)
        
        highDensityDiskEnclosureIdListRet = cliUtil.getHighDensityDiskEnclosureIdList(cli, LANG)
        if highDensityDiskEnclosureIdListRet[0] != True:
            errMsg += highDensityDiskEnclosureIdListRet[2]
            return (highDensityDiskEnclosureIdListRet[0], cliRet + highDensityDiskEnclosureIdListRet[1], errMsg)
        highDensityDiskEnclosureIdList = highDensityDiskEnclosureIdListRet[1]
        
        cliRetLinesExpModuleList = cliUtil.getHorizontalCliRet(expModuleRet)
        logicVersionOfDiskExpSet = set()
        logicVersionOfHighDensityDiskExpSet = set()
        
        for line in cliRetLinesExpModuleList:
            expModuleId = line.get("ID")
            enclosureId = expModuleId.split(".")[0]
            logicVersionExp = line.get("Logic Version")
            if len(logicVersionExp) > 0 and logicVersionExp != "--":
                if enclosureId in highDensityDiskEnclosureIdList:
                    logicVersionOfHighDensityDiskExpSet.add(logicVersionExp)
                else:
                    logicVersionOfDiskExpSet.add(logicVersionExp)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.logic.version.of.expansion.module", expModuleId)
                LOGGER.logNoPass("Cannot get information about logic version of expansion module")
        
        if len(logicVersionOfDiskExpSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.expansion.module.on.disk.inconsistent", 
                (versionName, ", ".join(logicVersionOfDiskExpSet)))
            LOGGER.logNoPass("The logic versions of all expansion modules in disk enclosures are inconsistent")
        
        if len(logicVersionOfHighDensityDiskExpSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.expansion.module.on.high-density.inconsistent", 
                (versionName, ", ".join(logicVersionOfHighDensityDiskExpSet)))
            LOGGER.logNoPass("The logic versions of all expansion modules in high-density disk enclosures are inconsistent")
            
        if flag:
            LOGGER.logPass()   
               
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
