# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    SES版本检查: 
        1 所有控制器的SES Version一致表示正常；
        2 硬盘框或高密框的所有级联模块的SES Version均存在且分别一致表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    versionName = "SES"
    
    try:
        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        controllerRet = cliUtil.getSplitedCliRet(cliRet, "Controller:")
        cliRetLinesList = cliUtil.getVerticalCliRet(controllerRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.version.of.controller")
            LOGGER.logNoPass("Cannot get information about version of controllers")
            return (False, cliRet, errMsg)
        
        sesVersionSet = set()
        for retDict in cliRetLinesList:
            controllerId = retDict.get("Controller")
            sesVersion = retDict.get("SES Version")
            if len(sesVersion) > 0:
                sesVersionSet.add(sesVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.ses.version.of.controller", controllerId)
                LOGGER.logNoPass("Cannot get information about SES version of controller [%s]" % controllerId)

        if len(sesVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.controller.inconsistent", (versionName, ", ".join(sesVersionSet)))
            LOGGER.logNoPass("The SES versions of all controllers are inconsistent")
        
        expModuleRet = cliUtil.getSplitedCliRet(cliRet, "Expansion Module:")
        if len(expModuleRet) == 0:
            return (True, cliRet, errMsg)
        
        highDensityDiskEnclosureIdListRet = cliUtil.getHighDensityDiskEnclosureIdList(cli, LANG)
        if highDensityDiskEnclosureIdListRet[0] != True:
            errMsg += highDensityDiskEnclosureIdListRet[2]
            return (highDensityDiskEnclosureIdListRet[0], cliRet + highDensityDiskEnclosureIdListRet[1], errMsg)
        highDensityDiskEnclosureIdList = highDensityDiskEnclosureIdListRet[1]
        
        cliRetLinesExpModuleList = cliUtil.getHorizontalCliRet(expModuleRet)
        sesVersionExpOfDiskEncloSet = set()
        sesVersionExpOfHighDensityDiskSet = set()
        
        for line in cliRetLinesExpModuleList:
            expModuleId = line.get("ID")
            enclosureId = expModuleId.split(".")[0]
            sesVersionExp = line.get("SES Version")
            if len(sesVersionExp) > 0 and sesVersionExp != "--":
                if enclosureId in highDensityDiskEnclosureIdList:
                    sesVersionExpOfHighDensityDiskSet.add(sesVersionExp)
                else:
                    sesVersionExpOfDiskEncloSet.add(sesVersionExp)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.ses.version.of.expansion.module", expModuleId)
                LOGGER.logNoPass("Cannot get information about SES version of expansion module")
            
        if len(sesVersionExpOfDiskEncloSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.expansion.module.on.disk.inconsistent", 
                (versionName, ", ".join(sesVersionExpOfDiskEncloSet)))
            LOGGER.logNoPass("The SES versions of all expansion modules in disk enclosures are inconsistent")
        
        if len(sesVersionExpOfHighDensityDiskSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.expansion.module.on.high-density.inconsistent", 
                (versionName, ", ".join(sesVersionExpOfHighDensityDiskSet)))
            LOGGER.logNoPass("The SES versions of all expansion modules in high-density disk enclosures are inconsistent")
        
        if flag:
            LOGGER.logPass() 
                  
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (False, cliRet, common.getMsg(LANG, "query.result.abnormal"))
