# -*- coding: UTF-8 -*-
import cliUtil
import common
import os

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(devObj):
    '''
        健康检查前置脚本
    '''
    try:
        # 删除扩容评估中备份的DB数据
        sceneResPath = py_java_env.get("sceneResPath")
        if sceneResPath is not None:
            dbFilePath = sceneResPath + os.path.sep + "db.dat"
            if os.path.isfile(dbFilePath):
                try:
                    os.remove(dbFilePath)
                    LOGGER.logInfo("Backup DB data deleted successfully.")
                except Exception:
                    LOGGER.logInfo("Fail to Delete Backup DB data.")

        #检查用户名称是否非法（部分关键字作为用户名将影响CLI执行结果判断）
        loginUserName = py_java_env.get("devInfoMap").get("userName")
        LOGGER.logInfo("loginUserName is %s" % str(loginUserName))
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            return ('', dict(flag=False, des=common.getMsg(LANG, "loginUser.name.check.failure")))
        
        cmd = "show system general"
        cli = devObj.get("ssh")
        
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            errMsg = checkRet[2]
            LOGGER.logSysAbnormal()
            return ('', dict(flag=False, des=errMsg))
        
        cliRet = checkRet[1]
        status, errMsg = common.checkSystemStatus(cliRet, LANG)
        if status:
            return ('', dict(flag=True, des=common.getMsg(LANG, "check.pass")))
        else:
            LOGGER.logNoPass("The status of system is abnormal")
            return ('', dict(flag=False, des=errMsg))
        
    except Exception, exception:
        LOGGER.logException(exception)
        return ('', dict(flag=False, des=common.getMsg(LANG, "query.result.abnormal")))
    
    
USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True
