# -*- coding: UTF-8 -*-
import re

from frameone.util import common as frame_common

import cli_util_cache
import common_cache
import common
import cliUtil
from config import FAN_TEMPRETURE_RISK_MODE

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def countchar(s):
    s=s.upper()
    cnt = 0
    for c in s:
        if  ord("A")<=ord(c)<=ord("Z") or " " == c:
            cnt +=1
        else:
            continue
    return cnt

def execute(cli):
    """
    6.0.0，或者6.0.1且补丁版本小于SPH2（不含SPH2）
    如果“Mode=Manual Mode”且“Temperature=53”否则修改为此模式
    """
    change_bbu_temperature(cli)

    try:
        passRate = py_java_env.get("manualChkPassRate")
        manualChkItems = py_java_env.get("manualChkItems")
        manualChkRs = py_java_env.get("manualChkRs")
        cliRet = ""
        LOGGER.logNoPass("passRate:%s" % passRate)
        
        if manualChkItems and manualChkRs and len(manualChkItems) == len(manualChkRs):
            ljsutMaxLen = len(max(manualChkItems, key=len))
            if "zh" == LANG:
                cliRet += u"%s  %s\n" % (u"检查项".ljust(ljsutMaxLen,u"　"), u"检查结果")
            else:
                cliRet += "%s  %s\n" % ("Check Item".ljust(ljsutMaxLen), "Check Result")
            for i in xrange(0, len(manualChkItems)):
                itemName = manualChkItems[i]
                itemRs = manualChkRs[i]
                if "zh" == LANG:
                    if not itemRs:
                        itemRs = u"未检查"
                    #中文场景补齐字符串中中英文混杂时部分
                    cliRet += "%s  %s\n" % (itemName.ljust(ljsutMaxLen,u"　") + int(countchar(itemName) / 2) * u"　", itemRs)
                else:
                    if not itemRs:
                        itemRs = "Not Checked"
                    cliRet += "%s  %s\n" % (itemName.ljust(ljsutMaxLen), itemRs)
        
        if "100%" == passRate:
            return (True, cliRet, "")
        
        errMsg = "Pass ratio is %s" % passRate
        if "zh" == LANG:
            errMsg = u"人工检查通过率为：%s" % passRate
        return (False, cliRet, errMsg)

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


@frame_common.wrapAllExceptionLogged(logger=PY_LOGGER)
def change_bbu_temperature(cli):
    """
    6.0.0，或者6.0.1且补丁版本小于SPH2（不含SPH2）
    如果“Mode=Manual Mode”且“Temperature=53”否则修改为此模式
    """
    p_mode = common.getProductModeFromContext(PY_JAVA_ENV)
    if p_mode not in FAN_TEMPRETURE_RISK_MODE:
        LOGGER.logInfo("not risk model, no need change fan temperature!")
        return
    (
        flag,
        p_version,
        p_patch,
        ret,
        e_msg,
    ) = common_cache.get_version_and_patch_cache(PY_JAVA_ENV, cli, LOGGER)
    p_patch_reg = re.compile(r"SPH(\d+)")
    res = p_patch_reg.match(p_patch)
    if res:
        p_patch = res.group(1)
    else:
        p_patch = 0
    if not (
        p_version == "6.0.0" or (p_version == "6.0.1" and int(p_patch) < 2)
    ):
        LOGGER.logInfo("not risk ver, no need change fan temperature!")
        return
    flag, cli_ret, e_msg = cliUtil.enterDeveloperMode(cli, LANG)
    if flag is not True:
        LOGGER.logError("enter developer failed!")
        return
    cli_ret, temperature, fan_mode = cli_util_cache.get_smartcooling_mode(
        cli, LANG
    )
    if temperature == "53" and fan_mode.lower() == 'manual mode':
        LOGGER.logInfo("no need change fan temperature!")
        return

    # 不是53度就修改值。
    chang_temperature(cli)

    cli_ret, temperature, fan_mode = cli_util_cache.get_smartcooling_mode(
        cli, LANG
    )
    if temperature == "53" and fan_mode.lower() == 'manual mode':
        LOGGER.logInfo("change fan Temperature to 53* success!")
        return
    LOGGER.logError("change fan tmperature failed!")


def chang_temperature(cli):
    cmd = "change smartcooling_mode mode=Manual_Mode temperature=53"
    cli_ret = cli.execCmdNoLog(cmd)
    while '(y/n)' in cli_ret:
        cli_ret = cli.execCmd('y')
    LOGGER.logInfo("update sct success!")
