# -*- coding: UTF-8 -*-

import cliUtil
import common
from cbb.common.conf.productConfig import SAS_INTERNAL_PDT_MODEL_TUPLE
from cbb.frame.base import baseUtil as cbbBaseUtil
from cbb.frame.rest import restUtil
from cbb.frame.adapter.replace_adapter import compare_version
from frameone.util import common as frameCommon
from frameone.util import contextUtil
# noinspection PyUnresolvedReferences
from java.lang import Exception as JException

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
# noinspection PyUnresolvedReferences
context = contextUtil.getContext(py_java_env)


# noinspection PyUnresolvedReferences
@frameCommon.fakeProgress(py_java_env, totalSeconds=15, logger=LOGGER,
                          interval=1)
def execute(cli):
    """ 检查内双活license,只检查Dorado V6高端

    :param cli:
    :return:
    """
    try:
        dev_info = py_java_env.get("devInfo")
        product_model = str(dev_info.getDeviceType())
        # 非DoradoV6高端，通过, OceanStor 6810 不支持内双活
        if not cbbBaseUtil.isDoradoV6HighEnd(product_model) or \
                product_model == "OceanStor 6810":
            return cliUtil.RESULT_NOSUPPORT, "", ""

        exp_info = py_java_env.get("expInfo")
        # 原集群控制器数量
        dev_ctrl_num = int(exp_info.getDevCtrlsNum())
        # 扩容后控制器数量
        exp_ctrl_num = int(exp_info.getExpCtrlsNum())
        # 非单引擎扩多引擎场景，不涉及
        if dev_ctrl_num > 4 or exp_ctrl_num <= 4:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        # 内部型号
        internal_product_model = exp_info.getInternalModel()
        LOGGER.logInfo("internalProductModel is: %s" % internal_product_model)

        # 查询是否有内双活license
        license_rec = ""
        try:
            rest = contextUtil.getRest(context)
            has_license_flag, license_rec = \
                restUtil.CommonRest.hasInnerLicense(rest)
        except (JException, Exception) as ex:
            LOGGER.logInfo("Query license exception: {}".format(ex))
            return cliUtil.RESULT_NOCHECK, license_rec, common.getMsg(
                LANG, "cannot.get.license.service.auth.info")

        # 有内双活license最大支持到8控。
        if has_license_flag and exp_ctrl_num > 8:
            LOGGER.logInfo("exp_ctrl_num:{}".format(exp_ctrl_num))
            return False, license_rec, (common.getMsg(LANG, "inner.hypermetro.license.expansion.ctrl.num.limit"))

        # SAS设备，若有内双活license，则检查不通过，否则通过；
        if internal_product_model in SAS_INTERNAL_PDT_MODEL_TUPLE:
            if has_license_flag:
                err_msg = common.getMsg(LANG, "inner.hypermetro.license.exists")
                return False, license_rec, err_msg
            return True, license_rec, ""

        # NVMe/IP SAS设备，需要选择“是否需要内双活特性”
        else:
            # 从上下文中获取是否需要内双活特性的选择
            require_inner_metro = py_java_env.get("requireInnerMetro")
            LOGGER.logInfo("requireInnerMetro: %s" % require_inner_metro)
            # 选择需要内双活，但是未导入内双活license，不通过
            if require_inner_metro and not has_license_flag:
                err_msg = common.getMsg(LANG,
                                        "inner.hypermetro.license.not.exist")
                return False, license_rec, err_msg
            # 选择需要内双活，且已经导入内双活license，615之前版本，建议优化。
            product_version = str(dev_info.getProductVersion())
            LOGGER.logInfo("product_version: {}".format(product_version))
            if require_inner_metro and has_license_flag and compare_version(product_version, "6.1.5RC1") < 0:
                err_msg = common.getMsg(LANG, "inner.hypermetro.license.not.support.switch", product_version)
                return cliUtil.RESULT_WARNING, license_rec, err_msg
            # 选择不需要内双活，但已导入内双活license，不通过
            if not require_inner_metro and has_license_flag:
                err_msg = common.getMsg(LANG, "inner.hypermetro.license.exists")
                return False, license_rec, err_msg
            return True, license_rec, ""

    except (JException, Exception) as ex:
        LOGGER.logInfo("check exception: {}".format(ex))
        err_msg = common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, "", err_msg
