# -*- coding:utf-8 -*-

import common
from common_utils import get_err_msg
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
# noinspection PyUnresolvedReferences
from utils import Products

# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
all_ret = []
NAS_CTRL_NUM = 8  # NAS双活最多支持扩到8控
NAS_CTRL_NUM_PLUS = 16  # D5600/D6000 V7及以后版本NAS双活最多支持扩到16控


def execute(cli):
    """
    NAS双活节点规格检查
    :param cli:
    :return:
    """
    try:
        dev_info = PY_JAVA_ENV.get("devInfo")
        product_version = str(dev_info.getProductVersion())
        LOGGER.logInfo("product_version: {}".format(product_version))
        # 版本6.1.2RC1以下，直接通过
        if Products.compareVersion(product_version, "6.1.2RC1") < 0:
            return True, "", ""
        # 检查是否有内双或
        flag, cli_ret = has_fs_hyper_metro_domain(cli)
        if flag is not True:
            return True, "\n".join(all_ret), ""

        # 判断内双或是否激活
        flag, err_msg = is_activated(cli_ret)
        if flag is not True:
            return False, "\n".join(all_ret), err_msg

        # 判断是否扩到8控
        ctrl_number = int(PY_JAVA_ENV.get("expCtrl"))
        LOGGER.logInfo("ctrl_number: {}".format(ctrl_number))
        product_model = str(dev_info.getDeviceType())
        LOGGER.logInfo("product_model: {}".format(product_model))
        if baseUtil.is_support_16_ctrl_with_nas(product_model, product_version):
            limit_nas_ctrl_num = NAS_CTRL_NUM_PLUS
            err_msg_key = "NAS.ctrl.more.16"
        else:
            limit_nas_ctrl_num = NAS_CTRL_NUM
            err_msg_key = "NAS.ctrl.more.8"
        if ctrl_number > limit_nas_ctrl_num:
            return False, "\n".join(all_ret), get_err_msg(LANG, err_msg_key)
        return True, "\n".join(all_ret), ""
    except Exception as e:
        LOGGER.logException(e)
        err_msg = common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, "\n".join(all_ret), err_msg


def has_fs_hyper_metro_domain(cli):
    """
    检查是否为NAS双活
    """
    cmd = "show fs_hyper_metro_domain general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd,
                                                        True, LANG)
    # 不支持NAS，不支持该命令
    if flag is not True and \
            "the current device does not support NAS" in cli_ret:
        return False, cli_ret
    if flag is not True:
        raise common.UnCheckException(err_msg, cli_ret)
    all_ret.append(cli_ret)
    LOGGER.logInfo("cli_ret: {}".format(cli_ret))
    if "Command executed successfully" in cli_ret:
        return False, cli_ret
    return True, cli_ret


def is_activated(cli_ret):
    """"
    判断NAS双活是否激活
    """
    hyper_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    for hyper_info in hyper_info_list:
        running_status = hyper_info.get("Running Status")
        if "Connecting" in running_status:
            return False, get_err_msg(LANG, "NAS.hyper.failed")

    return True, ""
