# coding: UTF-8

import cliUtil
import common
import config
import expandconfig
from frameone.adapter import connectionFactory
from frameone.util import contextUtil
from frameone.util import common as frameCommon

dataDict = contextUtil.getContext(py_java_env)
expConfigObj = expandconfig.ExpandConfig(py_java_env)
LANG = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

DATA_PERSISTENCE_RESULT = {
    "0": False,  # 不满足数据持久度。
    "1": True,  # 满足数据持久度。
    "2": cliUtil.RESULT_NOSUPPORT,  # 不需要检查数据持久度。
    "3": cliUtil.RESULT_NOCHECK  # 检查失败。
}

MSG_TIER = {
    "0": "Extreme Performance",
    "1": "Performance",
    "2": "Capacity",
}

restRet = ""


@frameCommon.wrapInspectException(lan=LANG, logger=logger, originalInfo=restRet)
@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=logger, interval=1)
def execute(cli):
    global restRet
    datas = getCheckDatas()
    logger.logInfo('get the check data result:%s' % datas)
    if not datas:
        return (True, "", "")

    # 检查版本
    flag, sys, __, restRet, errMsg = common.getProductVersionAndHotPatchVersion(cli, logger, LANG)
    if flag != True:
        return flag, restRet, errMsg

    if sys.startswith("V3") and sys < "V300R006C50":
        return True, restRet, ""

    if sys.startswith("V5") and sys < "V500R007C30":
        return True, restRet, ""

    restService = connectionFactory.getRestService(dataDict)
    retModule = "Command information:Domain id:%s, Tier type:%s, Disk number:%s, Average sectors number of single disk:%s"
    domainMsg = []
    flag = True
    for data in datas:
        domaianId = data.get("domainId")
        tierType = data.get("tierType")
        diskNumInt = data.get("diskNum")
        diskCapacityInt = int(data.get("diskCapacityInt"))  # 扇区数
        tierDsc = MSG_TIER.get(tierType)

        restRet = restRet + "\n" + retModule % (domaianId, tierDsc, diskNumInt, diskCapacityInt)
        dataPersistentCheckResult = restService.getDataPersistence(domaianId, tierType, diskNumInt, diskCapacityInt)
        restRet = restRet + "\n" + "dataPersistentCheckResult:%s" % dataPersistentCheckResult
        result = DATA_PERSISTENCE_RESULT.get(dataPersistentCheckResult, cliUtil.RESULT_NOCHECK)
        if result == False:
            # 硬盘域（ID:%s）的Tier层级(%s)不满足数据持久度。
            domainMsg.append(common.getMsg(LANG, "check.data.persistence.not.pass", (domaianId, tierDsc)))

        elif result == cliUtil.RESULT_NOCHECK:
            # 检查对应数据持久度出错：硬盘域ID:%s，Tier层级：%s。
            domainMsg.append(common.getMsg(LANG, "check.data.persistence.error", (domaianId, tierDsc)))

        flag = getResult(flag, result)

    return (flag, restRet, "".join(domainMsg))


def getCheckDatas():
    datas = []
    expDiskInfoDict = expConfigObj.getExpDiskInfo()
    if not expDiskInfoDict:
        logger.logInfo('Create new disk domain scene, need not to check')
        return []

    expDiskLis = sorted(expDiskInfoDict.items(), key=lambda x: x[0], reverse=True)

    for item in expDiskLis:
        curDomain = {}  # {tierType:{diskDomaind:0,tierType:1,diskNum,8,diskCapacityInt:12}}
        domainId = item[0]
        expList = item[1]
        for expObj in expList:

            tierType = str(config.DISK_TYPE_LEVEL_ENUM.get(expObj.getDiskType()))
            diskNum = expObj.getDiskNum()
            sector = config.DISK_TYPE_SECTOR.get(expObj.getDiskType(), 520)
            diskCapacityInt = int(common.changUnit2KB(str(expObj.getDiskCapacity()) + "GB")[1] / sector)
            tierDict = curDomain.get(str(tierType), {})
            if not tierDict:
                tierDict = {"domainId": domainId, "tierType": tierType, "diskNum": diskNum,
                            "diskCapacityInt": diskCapacityInt}
                curDomain[str(tierType)] = tierDict
                continue

            totalNum = tierDict.get("diskNum") + diskNum
            if totalNum == 0:
                logger.logWarning("The total value of diskNum couldn't be zero, reset to one")
                totalNum = 1
            tierDict["diskCapacityInt"] = (tierDict.get("diskNum") * tierDict.get(
                "diskCapacityInt") + diskNum * diskCapacityInt) / totalNum
            tierDict["diskNum"] = totalNum
            curDomain[str(tierType)] = tierDict
        datas.extend(curDomain.values())
    return datas


def getResult(perFlag, curFlag):
    if perFlag == curFlag:
        return perFlag

    if perFlag == False or curFlag == False:
        return False

    if perFlag == cliUtil.RESULT_NOCHECK or curFlag == cliUtil.RESULT_NOCHECK:
        return cliUtil.RESULT_NOCHECK

    if perFlag == True or curFlag == True:
        return True

    return curFlag
