# -*- coding: UTF-8 -*-
import common
from cbb.frame.base import baseUtil
from cbb.business.operate.checkitems import check_required_hot_patch
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.base import product
# noinspection PyUnresolvedReferences
from java.lang import Exception as JException


# 要求的补丁配置
REQUIRED_PATCH_LIST = [
    {
        "product_version": "V500R007C10",
        "required_patch": "V500R007C10SPH019",
        "product_series": "ConvergedStorage",
        "product_models": [
            "18500 V5", "18500F V5", "18800 V5", "18800F V5", "5500 V5",
            "5500F V5", "5600 V5", "5600F V5", "5800 V5", "5800F V5",
            "6800 V5", "6800F V5", "2800 V5", "5300F V5"]
    },
    {
        "product_version": "V500R007C30SPC100",
        "required_patch": "V500R007C30SPH109",
        "product_series": "ConvergedStorage",
        "product_models": [
            "18500 V5", "18500F V5", "18800 V5", "18800F V5", "5500 V5",
            "5500F V5", "5600 V5", "5600F V5", "5800 V5", "5800F V5",
            "6800 V5", "6800F V5", "2800 V5", "5300F V5"]
    },
    {
        "product_version": "V300R001C21SPC100",
        "required_patch": "V300R001C21SPH105",
        "product_series": "Dorado",
        "product_models": [],
    },
]
# Kunpeng要求的补丁配置
REQUIRED_PATCH_KUNPENG_LIST = [
    {
        # 新扩引起版本无法同步固件版本（升级组）
        "product_version": "V500R007C60SPC300",
        "required_patch": "V500R007C60SPH302",
        "product_series": "ConvergedStorage",
        "product_models": []
    },
]



def execute(cli):
    """ 检查补丁版本是否满足扩控要求

    :param cli: cli连接
    :return:
    """
    context = py_java_env.get("context")
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    lang = contextUtil.getLang(context)
    cli_ret = ""
    try:
        # 获取命令回显，用于界面显示
        cli_ret = get_ret(cli, lang)

        # 检查补丁
        patch_conf = REQUIRED_PATCH_LIST
        devInfo = common.getCurDeviceInfo(py_java_env)
        if product.isKunpeng(str(devInfo.getProductVersion())):
            patch_conf = REQUIRED_PATCH_KUNPENG_LIST

        flag, dev_version, _, _, required_patch = \
            check_required_hot_patch.execute(context, patch_conf, cli=cli)
        # 检查不通过
        if flag is not True:
            errMsg = common.getMsg(lang, "exp.hotpatch.ver.error",
                                   (dev_version, required_patch))
            return False, cli_ret, errMsg
        return True, cli_ret, ""
        
    except (JException, Exception) as exception:
        logger.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(lang, "query.result.abnormal"))


def get_ret(cli, lang):
    """ 获取命令回显，不管是否执行成功

    :param cli: cli连接
    :param lang: 语言
    :return:
    """
    sys_cmd = "show system general"
    version_cmd = "show upgrade package"
    all_ret = list()
    for cmd in [sys_cmd, version_cmd]:
        cli_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        all_ret.append(cli_ret[1])
    return "\n".join(all_ret)
