# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PATCH_VERSION = {
                 "V300R003C10SPC100":"V300R003C10SPH106",
                 "V300R003C20SPC200":"V300R003C20SPH207",
                 "V300R005C00SPC300":"V300R005C00SPC302",
                 }
DISK_TYPE_WHITE_LIST = ["SSD","SSD SED"]

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    """
    TRIM问题导致多控复位
        判断SSD盘和版本检查顺序不可更换
    """
    cliRet = ""
    try:
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, LOGGER)
        #进度开始
        common.inProcess(py_java_env)
        LOGGER.logInfo("process Thread started!")
        
        #检查SSD盘是否存在
        ret = isExistSSD(cli)
        if True != ret[0]:
            return ret
        
        #检查版本是否匹配
        cliRet = ret[1]
        verRet = checkVer(cli)
        cliRet = cliRet + verRet[1]
        return (verRet[0], cliRet, verRet[2])
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        common.finishProcess(py_java_env)
        LOGGER.logInfo("finish process!")

def isExistSSD(cli):
    '''
    @summary: 原阵列或待扩硬盘是否存在SSD盘
    @return: 不存在：False，存在：True
    '''
    errMsg = ""
    
    #检查待扩控
    expDiskList = py_java_env.get("expDiskList")
    if expDiskList:
        for diskcfg in expDiskList:
            diskModel = str(diskcfg.get("diskModel"))
            if diskModel.upper() in DISK_TYPE_WHITE_LIST:
                return (True, "", "")
    #检查原阵列
    cmd = "show disk general |filterRow column=Type predict=match value=SSD logicOp=or column=Type predict=match value=SSD\sSED"
    checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if checkRet[0] != True: 
        return checkRet
    
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
    
    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.disk.info")
        LOGGER.logNoPass("Cannot get information about disk status")
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
    
    return (True, cliRet, "")
    
def checkVer(cli):
    '''
    @summary: 检查产品版本及补丁版本
    '''
    errMsg = ""
    
    ret, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
    cliRet = ret[1]
    if not ret[0]:
        LOGGER.logInfo("get product version failed.")
        return (cliUtil.RESULT_NOCHECK,cliRet,ret[2])
    
    productVerRet = common.getCurrentVersion(softwareVersionList, LANG)
    if not productVerRet[0]:
        LOGGER.logInfo("get current version failed.")
        return (cliUtil.RESULT_NOCHECK,cliRet,ret[2])
    
    productVer = productVerRet[1]
    if productVer == "V300R003C20" or "V300R005C01" in productVer:
        errMsg = common.getMsg(LANG, "ssd.not.support.sys.version", productVer)
        return (False,cliRet,errMsg)
    
    if productVer not in PATCH_VERSION.keys():
        return (cliUtil.RESULT_NOSUPPORT,cliRet,"")
    
    patchRet = common.getHotPatchVersion(hotPatchVersionList, LANG)
    if not patchRet[0]:
        LOGGER.logInfo("get patch version failed.")
        return (cliUtil.RESULT_NOCHECK, cliRet, patchRet[2])
    
    patchVer = patchRet[1].upper()
    if patchVer == "--" or  patchVer < PATCH_VERSION.get(productVer):
        LOGGER.logNoPass("patch[%s] is too old."%patchVer)
        errMsg = common.getMsg(LANG, "dm.patch.too.old",patchVer)
        return (False, cliRet, errMsg)
      
    return (True, cliRet, "")
