# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware

from cbb.frame.base.baseUtil import is_computing_dev

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        电源状态检查：
        Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show power_supply"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0 and not is_computing_dev(common.getProductModeFromContext(py_java_env)):
            errMsg = common.getMsg(LANG, "cannot.get.power.supply.info")
            LOGGER.logNoPass("Cannot get information about power supply")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            power_id = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.health.status.abnormal", (power_id, healthStatus))
                LOGGER.logNoPass("The Health Status of power supply [%s] is abnormal (Health Status:%s)" % 
                    (power_id, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "power.supply.running.status.abnormal", (power_id, runningStatus))
                LOGGER.logNoPass("The Running Status of power supply [%s] is abnormal (Running Status:%s)" % 
                    (power_id, runningStatus))
            if healthStatus != common.STATUS_NORMAL or runningStatus != common.STATUS_ONLINE:
                # 获取电源硬件的BOM： 电子标签中的Item值 -> SN号中获取BOM值 -> Item值
                cliRet, eLabel = get_electronic_label_item(cli, power_id, cliRet)
                eLabel = hardware.getHardwareBomCode("Power",cli,power_id)[1] if not eLabel else eLabel
                if len(eLabel) == 0:
                    eLabel = 'Unknown'
                errMsg += common.getMsg(LANG, "hardware.bom.info", (power_id, eLabel))
                LOGGER.logNoPass("The Hardware ID: [%s] BOMCode:%s" % (power_id, eLabel))
        
        if flag:
            LOGGER.logPass()

        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def get_electronic_label_item(cli, power_id, cli_ret):
    cmd = "show power_supply power_supply_id={}".format(power_id)
    _, ret, _ = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    cli_ret += "\n\n" + ret
    return cli_ret, cliUtil.getVerticalCliRetFilterElabel(ret)[0].get("Item_1", "")
