# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config

from utils import Products

from common import UnCheckException
from common_cache import not_support_nas_domain
import common_utils

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ''

SAN_DOMAIN_CMD = "show hyper_metro_domain general"
NAS_DOMAIN_CMD = "show fs_hyper_metro_domain general"
SAN_DOMAIN_DETAIL_CMD = "show hyper_metro_domain general domain_id=%s"
NAS_DOMAIN_DETAIL_CMD = "show fs_hyper_metro_domain general domain_id=%s"


def execute(cli):
    """
    双活仲裁服务器配置一致性检查
    :param cli:
    :return:
    """
    global allCliRet
    not_pass_msg = []
    suggestion_msg = []
    no_check_msg = []
    try:
        localDevSn = PY_JAVA_ENV.get("devInfo").getDeviceSerialNumber()
        allCliRet += "ON LOCAL DEVICE(SN:%s)" % localDevSn
        isRisk = checkIsRiskVersion(localDevSn)
        LOGGER.logInfo("isRisk : %s, " % isRisk)
        if isRisk is not True:
            return True, allCliRet, ''
        # 检查是否有双活Domain域
        domain_dict = getDomainInfo(localDevSn, SAN_DOMAIN_CMD)
        nas_domain_dict = getDomainInfo(localDevSn, NAS_DOMAIN_CMD)
        total_domain_dict = domain_dict.copy()
        total_domain_dict.update(nas_domain_dict)
        LOGGER.logInfo("total domain dict is:{}".format(total_domain_dict))
        if not total_domain_dict:
            return True, allCliRet, ''
        # 检查是否添加了远端设备
        flag, addedSnList, errMsg = common.checkAddedRemoteDevSn(py_java_env, LANG)
        if flag is not True:
            return common_utils.get_result_bureau(PY_JAVA_ENV, allCliRet, errMsg)
        LOGGER.logInfo("checkAddedRemoteDevSn addedSnList:%s" % addedSnList)
        san_remote_dev = getRemoteDeviceInfo(localDevSn, domain_dict)
        nas_remote_dev = getRemoteDeviceInfo(localDevSn, nas_domain_dict)
        LOGGER.logInfo("domainRemoteDevDict :%s" % san_remote_dev)
        local_san_domain = getDomainDetailInfo(
            localDevSn, domain_dict, SAN_DOMAIN_DETAIL_CMD)
        local_nas_domain = getDomainDetailInfo(
            localDevSn, nas_domain_dict, NAS_DOMAIN_DETAIL_CMD)
        local_sn_dct, ret = getQuoServerSn(localDevSn)
        allCliRet += "\n{}".format(ret)
        ret_list = []
        checked_device = []
        # 检查san
        check_domain_quorum(
            san_remote_dev, addedSnList, local_san_domain, local_sn_dct,
            SAN_DOMAIN_DETAIL_CMD, not_pass_msg, suggestion_msg, no_check_msg,
            ret_list, checked_device)
        # 检查nas
        check_domain_quorum(
            nas_remote_dev, addedSnList, local_nas_domain, local_sn_dct,
            NAS_DOMAIN_DETAIL_CMD, not_pass_msg, suggestion_msg, no_check_msg,
            ret_list, checked_device)
        allCliRet += "\n".join(ret_list)
        return common_utils.merge_result(
            not_pass_msg, suggestion_msg, no_check_msg, [allCliRet], PY_JAVA_ENV)

    except UnCheckException as unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if not unCheckException.flag:
            return cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg

        return unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg
    except Exception as e:
        LOGGER.logError(e)
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal")


def check_domain_quorum(
        domain_info_dict, added_sn_list, local_domain_info, local_sn_dct,
        domain_detail_cmd, not_pass_msg, suggestion_msg, no_check_msg,
        ret_list, checked_device
):
    for domain_id, remote_dev_sn in domain_info_dict.items():
        if remote_dev_sn not in added_sn_list:
            tmp_msg = common.getMsg(
                LANG, "not.add.remote.device.again", remote_dev_sn)
            no_check_msg.append(tmp_msg)
            continue
        ret_list.append("\n\nON REMOTE DEVICE(SN:{})".format(remote_dev_sn))
        remote_domain_info = get_remote_domain_detail_info(
            remote_dev_sn, domain_id, domain_detail_cmd)
        remote_server_name = remote_domain_info.get(domain_id, {}).get(
            'quoServerName', '')
        local_server_name = local_domain_info.get(domain_id, {}).get(
            'quoServerName', '')
        remote_sn_dct, ret = getQuoServerSn(remote_dev_sn)
        ret_list.append(ret)
        remote_sn = remote_sn_dct.get(remote_server_name, '')
        local_sn = local_sn_dct.get(local_server_name, '')
        LOGGER.logInfo("local Domain:{} remote Domain:{}".format(
            local_domain_info, remote_domain_info))
        suggest_temp, not_pass_temp = checkQuoServerInfo(
            [domain_id], local_domain_info, remote_domain_info)
        if suggest_temp:
            suggestion_msg.append(suggest_temp)
        if not_pass_temp:
            not_pass_msg.append(not_pass_temp)
        if suggest_temp or not_pass_temp:
            continue
        LOGGER.logInfo("Sn local:{},remote:{}".format(local_sn, remote_sn))
        if local_sn != remote_sn:
            not_pass_msg.append(common.getMsg(
                LANG, "hypermetro.quorum.consistence.sn.diff",
                (domain_id, local_sn, remote_sn)))


def getQuoServerSn(devSn):
    """
    获取仲裁服务器SN
    :param devSn:
    :return:
    """

    cmd = "arb showall"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
    retLines = cliRet.splitlines()
    ret_lines_len = len(retLines)
    sever_sn_dct = {}
    if flag != True:
        LOGGER.logInfo("Failed to get information about quorum server info. errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, allCliRet)
    if ret_lines_len > 0:
        for i in range(1, ret_lines_len):
            name_line = retLines[i].strip()
            sn_line = retLines[i - 1].strip()
            if name_line.startswith('name:') and sn_line.startswith('sn:'):
                name_list = name_line.split(':')
                server_name = name_list[1].strip()[:-1]
                if not server_name:
                    continue
                snList = sn_line.split(":")
                if len(snList) >= 2:
                    sn = snList[1].strip()[:-1]
                    sever_sn_dct[server_name] = sn
    return sever_sn_dct, cliRet


def checkQuoServerInfo(domain_id_list, localDomainInfoDict,
                       remoteDomainInfoDict):
    """
    检查服务器名称和仲裁模式
    :param domain_id_list:
    :param localDomainInfoDict:
    :param remoteDomainInfoDict:
    :return:
    """
    sugg_error_msg = ''
    not_pass_msg = ''
    for domainId in domain_id_list:
        localDomainInfo = localDomainInfoDict[domainId]
        remoteDomainInfo = remoteDomainInfoDict.get(domainId, {})
        localQuoServerName = localDomainInfo.get("quoServerName", '')
        remoteQuoServerName = remoteDomainInfo.get("quoServerName", '')
        localQuoModel = localDomainInfo.get("quoModel", '')
        remoteQuoModel = remoteDomainInfo.get("quoModel", '')

        # 标准2
        if all(
                [
                    not localQuoServerName,
                    not remoteQuoServerName,
                    localQuoModel == "Static Priority",
                    remoteQuoModel == "Static Priority",
                ]
        ):
            if common.is_opening_delivery_inspect(PY_JAVA_ENV):
                not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.no.server", domainId)
            else:
                sugg_error_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.no.server", domainId)
            continue

        # 标准3
        if all(
                [
                    localQuoServerName,
                    remoteQuoServerName,
                    localQuoModel == "Static Priority",
                    remoteQuoModel == "Static Priority",
                ]
        ):
            not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.static.mode", domainId)
            continue

        # 标准4
        if all(
                [
                    not localQuoServerName,
                    not remoteQuoServerName,
                    localQuoModel != "Static Priority",
                    remoteQuoModel != "Static Priority",
                ]
        ):
            not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.no.server.and.not.static", domainId)
            continue

        # 标准5
        if (not localQuoServerName and remoteQuoServerName) or (localQuoServerName and not remoteQuoServerName):
            if (not localQuoServerName and remoteQuoServerName):
                not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.name.local.null", domainId)
            else:
                not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.name.remote.null", domainId)

        # 检查标准6
        if localQuoModel != remoteQuoModel:
            not_pass_msg += common.getMsg(LANG, "hypermetro.quorum.consistence.server.mode.diff", domainId)

    return sugg_error_msg, not_pass_msg


def get_remote_domain_detail_info(dev_sn, domain_id, cmd_str):
    domain_info_dict = {}
    cmd = cmd_str % domain_id
    flag, ret, err_msg = common.getObjFromFile(
        py_java_env, LOGGER, dev_sn, cmd, LANG)
    if not_support_nas_domain(ret):
        return domain_info_dict
    if flag is not True:
        raise UnCheckException(err_msg, allCliRet)
    domain_info_list = cliUtil.getVerticalCliRet(ret)
    for domain_info in domain_info_list:
        quoServerName = domain_info.get("Quorum Server Name", '')
        if not quoServerName:
            quoServerName = domain_info.get("Quorum Name", '')
        quoServerName = "" if quoServerName == "--" else quoServerName
        quoModel = domain_info.get("Quorum Mode", "")
        domain_info_dict[domain_id] = {
            "quoServerName": quoServerName,
            "quoModel": quoModel
        }
    return domain_info_dict


def getDomainDetailInfo(devSn, domainIdList, cmd_str):
    """
    获取domain详细信息
    :param devSn:
    :param domainIdList:
    :param cmd_str:
    :return:
    """
    global allCliRet
    domainInfoDict = {}
    for domainId in domainIdList:
        cmd = cmd_str % domainId
        flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
        if not cliUtil.hasCliExecPrivilege(cliRet):
            continue
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            LOGGER.logInfo("Failed to get information about HyperMetro domain. errMsg:%s" % errMsg)
            raise UnCheckException(errMsg, allCliRet)

        hyperMetroDomainInfoList = cliUtil.getVerticalCliRet(cliRet)
        for domainInfo in hyperMetroDomainInfoList:
            quoServerName = domainInfo.get("Quorum Server Name", '')
            if not quoServerName:
                quoServerName = domainInfo.get("Quorum Name", '')
            quoServerName = "" if quoServerName == "--" else quoServerName
            quoModel = domainInfo.get("Quorum Mode", "")
            domainInfoDict[domainId] = {"quoServerName": quoServerName,
                                        "quoModel": quoModel}

    return domainInfoDict


def checkIsRiskVersion(localDevSn):
    """
    检查版本是否是风险版本
    :param localDevSn:
    :return:
    """
    currentVersion = getCurrentVersion(localDevSn)
    if Products.isDigitalVer(currentVersion) or currentVersion.startswith("V700"):
        return True
    if currentVersion in config.RISK_QUORUM_PRODUCT_VERSION:
        return True
    return False


def getCurrentVersion(localDevSn):
    """
    获取版本信息
    :param localDevSn:
    :return:
    """
    global allCliRet
    cmd = "show upgrade package"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, localDevSn, cmd, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")
    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[softwareVersionIndex:hotPatchVersionIndex])
    for version in softwareVersionList:
        LOGGER.logInfo("getCurrentVersion :%s" % str(version.get("Current Version")))
        return str(version.get("Current Version"))


def getDomainInfo(devSn, cmd):
    """
    获取domain信息
    :param devSn:
    :param cmd:
    :return:
    """
    global allCliRet
    domainDict = {}
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn,
                                                 cmd, LANG)
    if not_support_nas_domain(cliRet):
        return domainDict
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about HyperMetro domain. errMsg:%s" % errMsg)
        raise UnCheckException(
            common.getMsg(LANG, "cannot.get.info", {"zh": u"双活域", "en": "HyperMetro domain"}.get(LANG)), allCliRet)

    hyperMetroDomainList = cliUtil.getHorizontalCliRet(cliRet)
    for domainInfo in hyperMetroDomainList:
        if cmd == NAS_DOMAIN_CMD and not common_utils.is_hypermetro_work_mode(
                domainInfo):
            continue
        domainId = domainInfo.get("ID", '')
        remoteDeviceId = domainInfo.get("Remote Device ID", '')
        if not domainId or not remoteDeviceId:
            LOGGER.logInfo(
                'DomainId or RemoteDeviceID is none. domainId : %s, remoteDeviceId : %s' % (domainId, remoteDeviceId))
            raise UnCheckException(common.getMsg(LANG, 'cannot.get.info',
                                                 {'zh': u'双活域id或远端设备id', 'en': 'domainID or remoteDeviceId'}.get(LANG)),
                                   allCliRet)
        domainDict[domainId] = remoteDeviceId

    return domainDict


def getRemoteDeviceInfo(devSn, domainDict):
    """
    获取远端设备
    :param devSn:
    :param domainDict:
    :return:
    """
    global allCliRet
    remoteDeviceDict = {}
    cmd = "show remote_device general"
    flag, cliRet, errMsg = common.getObjFromFile(py_java_env, LOGGER, devSn, cmd, LANG)
    if cliRet not in allCliRet:
        allCliRet = common.joinLines(allCliRet, cliRet)
    if flag is not True:
        LOGGER.logInfo("Failed to get information about remote device. errMsg:%s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", {"zh": u"远端设备", "en": "remote device"}.get(LANG)),
                               allCliRet)

    remoteDeviceList = cliUtil.getHorizontalCliRet(cliRet)
    for remoteDev in remoteDeviceList:
        remoteDeviceId = remoteDev.get("ID", '')
        remoteDeviceSn = remoteDev.get("SN", '')
        if not remoteDeviceId or not remoteDeviceSn:
            LOGGER.logInfo('RemoteDeviceId or remoteDeviceSn is none. remoteDeviceId : %s, remoteDeviceSn : %s' % (
                remoteDeviceId, remoteDeviceSn))
            raise UnCheckException(common.getMsg(LANG, 'cannot.get.info',
                                                 {'zh': u'远端设备id或远端设备sn', 'en': 'remoteDeviceId or remoteDeviceSn'}.get(
                                                     LANG)), allCliRet)
        for domainId in domainDict:
            if remoteDeviceId == domainDict[domainId]:
                remoteDeviceDict[domainId] = remoteDeviceSn

    return remoteDeviceDict
