# coding=UTF-8

# Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/03/13
@file: check_item_service_check_if_create_rep_in.py.py
@function:
@modify:
"""

import cliUtil
import common
from com.huawei.ism.tool.obase.exception import ToolException


PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

MIN_ALLOWED_PATCH_VAR_NUM = 6
NEED_CHECK_SOFT_VERSION = "6.0.0"
HYPER_METRO_FEATURE_ID = "63"
HYPER_REPLICATION_FEATURE_ID = "24"


def execute(cli):
    """
    检查方法：
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show upgrade package，获取系统软件版本和热补丁版本信息；
    步骤3 执行命令：show license，查询当前阵列的HyperMetro和HyperReplication特性的详细信息。
    检查标准：
    1 若步骤2中，系统版本为6.0.0，且未安装热补丁版本，或热补丁版本低于SPH3，
      则继续检查，否则检查通过；
    2 若步骤3中，HyperMetro和HyperReplication特性同时存在，
      即Feature ID:63和Feature ID:24同时存在，则检查不通过，否则检查通过。
    修复建议：
    1 若检查结果不通过，请安装SPH3或更高版本热补丁；
    2 若有任何疑问，请联系技术支持工程师。
    """
    try:
        all_cli_ret = ""
        flag, soft_ver, patch_ver, cli_ret, err_msg = \
            common.get_soft_and_patch_version(cli, LOGGER, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        # 命令没有执行成功
        if flag is not True:
            return flag, all_cli_ret, err_msg
        LOGGER.logInfo(
            "patch_ver:{0}, soft_ver:{1}".format(patch_ver, soft_ver))

        if soft_ver != NEED_CHECK_SOFT_VERSION:
            return True, all_cli_ret, err_msg

        patch_ver_num = 0 if patch_ver == "--" else int(patch_ver[3:])
        if patch_ver_num >= MIN_ALLOWED_PATCH_VAR_NUM:
            return True, all_cli_ret, err_msg

        # 以上条件不通过，则进行特性检查
        flag, cli_ret, err_msg = check_feature(cli, soft_ver, patch_ver)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        return flag, all_cli_ret, err_msg
    except ToolException as e:
        LOGGER.logException(e)
        return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
    except Exception as e:
        LOGGER.logException(e)
        return cliUtil.RESULT_NOCHECK, all_cli_ret, common.getMsg(
            LANG, "query.result.abnormal")


def check_feature(cli, soft_ver, patch_ver):
    """
    检查特性情况是否满足通过
    """
    cmd = "show license"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, False, LANG)
    if flag is not True:
        return flag, cli_ret, err_msg

    exist_feature_hyper_metro, exist_feature_hyper_replication = False, False

    cli_ret_lines = cliUtil.getVerticalCliRet(cli_ret)
    for line in cli_ret_lines:
        feature_id = line.get("Feature ID")
        if feature_id == HYPER_METRO_FEATURE_ID:
            exist_feature_hyper_metro = True
        elif feature_id == HYPER_REPLICATION_FEATURE_ID:
            exist_feature_hyper_replication = True
        if exist_feature_hyper_metro and exist_feature_hyper_replication:
            err_msg = common.getMsg(
                LANG, "if_create_Rep_in_V6.check.notpass",
                (soft_ver, patch_ver))
            return False, cli_ret, err_msg

    return True, cli_ret, err_msg
