# -*- coding: UTF-8 -*-
import cliUtil
import common
import time
import decimal

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    DLM内存利用率检查： 
        1、计算每个控制器的DLM内存使用率Used/Number，每30s执行一次总共执行6次，如果6次大于等于80%，则检查结果为建议优化。
        2、其他情况，检查结果为通过。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    allCliRet = ""
    allErrMsg = ""
    solutionVersion = "V300R003C20"
    noSupportVersion = "V300R002C10SPC200"
    try:
        #V3R3C20版本不涉及该问题
        flag , productversion , cliRet, errMsg = cliUtil.getProductVersionWithCliRet(cli, LANG)
        if flag != True:
            if not flag:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：获取产品版本并返回CLI回显（getProductVersionWithCliRet）执行失败
            return (flag, cliRet, errMsg)
        
        if productversion >= solutionVersion:
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg)
        
        checkRet = common.getProductVersionByUpgradePackage(cli, LANG)
        productversion = checkRet[3]
        if checkRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2])
        
        if productversion < noSupportVersion:
            return (cliUtil.RESULT_NOSUPPORT, checkRet[1], errMsg)
        
        #步骤1：获取所有控制器ID
        checkRet = cliUtil.getControllerIdList(cli, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2]  # 修改备注：获取所有控制器ID（getControllerIdList）执行失败
            return checkRet
        controllerIdList = checkRet[1]
        #步骤2：在Develope模式下面执行查询命令
        for i in range(0, 6):
            #每30秒执行一次，查询6次
            flag, controllerIdList, cliRet, errMsg = checkDlmMemoryUsage(cli, LANG, controllerIdList)
            allCliRet += cliRet
            allErrMsg += errMsg
            
            if flag != True:
                return (flag, allCliRet, errMsg)
            
            if len(controllerIdList) == 0:
                break
            
            time.sleep(30)
            
        if len(controllerIdList) != 0:
            flag = cliUtil.RESULT_WARNING
            LOGGER.logNoPass("dlm memory usage overproff controllerIdList is :[%s]" %controllerIdList)
            errMsg += common.getMsg(LANG, "dlm.memory.usage.failed" , ",".join(controllerIdList))
                    
        return (flag, allCliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
def checkDlmMemoryUsage(cli, LANG, controllerIdList):
    '''
    @summary: 检查单个控制器的DLM内存使用率
    @param cli: cli对象
    @param LANG: 语言环境
    @param controllerIdList: 控制器ID列表
    @return: controllerIdList:存在利用率大于等于80%的控制器列表
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    allCliRet = ""
    ctrIdList = controllerIdList[:]
    for ctrlId in ctrIdList:
        cmd = "show dlm mempool controller=%s" %ctrlId
        flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloper(cli, cmd, True, LANG)
        allCliRet += cliRet
        if flag != True: 
            LOGGER.logSysAbnormal()
            return (flag, controllerIdList,allCliRet, errMsg)
        
        cliRetLinesDictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(cliRetLinesDictList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.dlm.memory.usage.info")
            LOGGER.logNoPass("Cannot get information about dlm memory usage")
            return (False, controllerIdList,cliRet, errMsg)
        
        
        for lineDict in cliRetLinesDictList:
            dlmUsed = 0
            dlmNumber = 1
            
            if lineDict.get("Name") == "DLM common Pool":
                dlmNumber = float(lineDict.get("Number","1"))
                dlmUsed = float(lineDict.get("Used","0"))
                LOGGER.logInfo("ctrlId :[%s] dlm memory usage :[%s]" %(ctrlId ,str(decimal.Decimal(str(dlmUsed))/decimal.Decimal(str(dlmNumber)))))
                
                if decimal.Decimal(str(dlmUsed))/decimal.Decimal(str(dlmNumber)) < decimal.Decimal(str(0.8)):
                    controllerIdList.remove(ctrlId)
                    flag = True
                    
    return (flag, controllerIdList,allCliRet, errMsg)
