# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common_cache
import common
import cli_util_cache as cache_util
from cbb.frame.cli import cli_with_cache
from common import AsynProgress

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    '''
    双活LUN映射检查:
                存在LUN的"Exposed To Initiator"字段为"No"且"HyperMetro ID(s)"字段不为"--"，检查结果为不通过；否则检查结果为通过。
    '''
    flag = True
    errMsg = ""
    all_cli_ret_list = []
    myPthread = AsynProgress(py_java_env, LOGGER)
    myPthread.start_thread()
    try:
        # 获取未被映射的LUNID
        all_lun_info, cli_ret = common.get_all_lun_info_with_cache(
            PY_JAVA_ENV, cli, LOGGER)
        all_cli_ret_list.append(cli_ret)
        if not all_lun_info:
            return True, cli_ret, ""

        lun_id_list = [lun_info.get("ID") for lun_info in
                       all_lun_info]

        # 因数据量大，20min（用户可接受的时间）内未完成查询时不再做检查
        if "TOOLKIT_SEND_CMD_TIME_OUT" in cli_ret:
            errMsg = common.getMsg(LANG, "get.luninfo.timeout")
            return "NOCHECK", cli_ret, errMsg

        if not lun_id_list:
            return True, cli_ret, errMsg

        hy_lun_list, failed_lun_list, ret_list = checkLunHyperMetro(
            cli, lun_id_list)
        all_cli_ret_list.extend(ret_list)
        if hy_lun_list:
            flag = False
            errMsg += common.getMsg(LANG, "unmapped.hypermetro.lun",
                                    ",".join(hy_lun_list))
        if failed_lun_list:
            errMsg += common.getMsg(LANG, "cannot.get.lun.hypermetroid",
                                    ",".join(failed_lun_list))

        if flag:
            LOGGER.logPass()

        ret = common_cache.save_cli_ret_to_file(all_cli_ret_list,
                                                "service_hypermetro_lun",
                                                PY_JAVA_ENV, LOGGER)

        return (flag, ret, errMsg)

    except (ToolException, Exception) as e:
        LOGGER.logException(e)
        ret = common_cache.save_cli_ret_to_file(all_cli_ret_list,
                                                "service_hypermetro_lun",
                                                PY_JAVA_ENV, LOGGER)
        return (cliUtil.RESULT_NOCHECK, ret,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)


def checkLunHyperMetro(cli, lunIdList):
    """
    @summary: 检查lun是否是双活LUN
    @param lunIdList: 需要检查的LUN
    @return:True / False: 存在lun为双活LUN
            hyperMetroLunIdList： 双活LUNID列表
            cliRet：所有lun详细信息
    """
    failed_lun_list = []
    ret_list = []
    # 双活LUNID列表
    hy_lun_list = []

    dev_info = PY_JAVA_ENV.get("devInfo")
    sn = common.get_sn_from_env(PY_JAVA_ENV)
    obj_py = PY_JAVA_ENV.get("objectForPy")

    # 如果是使用config则不提前查询
    lun_info_dict_list = cache_util.get_lun_info_from_config(obj_py,
                                                             LOGGER,
                                                             sn)
    LOGGER.logInfo("config lun:{0}".format(len(lun_info_dict_list)))
    if lun_info_dict_list:
        for lun_info in lun_info_dict_list:
            lun_id = lun_info.get("ID")
            # V500R007C6x config中没有新增字段Is ROW LUN Child。
            if lun_id not in lunIdList:
                continue

            is_row_lun_child = lun_info.get("Is ROW LUN Child", "No")
            # row lun 的子LUN不检查
            if is_row_lun_child == 'Yes':
                continue

            tmp_list = []
            mapped_host = lun_info.get("Exposed To Initiator")
            # 获取HyperMetro ID(s),以判断是否为双活LUN
            hyper_id = lun_info.get("HyperMetro ID(s)")
            lun_id = lun_info.get("ID")
            tmp_list.append("\nID:{0}".format(lun_id))
            tmp_list.append("Exposed To Initiator: {0}".format(mapped_host))
            tmp_list.append("HyperMetro ID(s): {0}\n".format(hyper_id))
            ret_list.append("\n".join(tmp_list))

            # 如果是未映射的LUN 则跳过
            if mapped_host == 'Yes':
                continue

            # 如果是双活LUN，则记录上报
            if hyper_id != "--" and hyper_id != "" and hyper_id != []:
                hy_lun_list.append(lun_id)
    else:
        for lunId in lunIdList:
            cmd = "show lun general lun_id=%s" % lunId
            cmdRet, cli_ret, err_msg = cli_with_cache. \
                execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli,
                                                   cmd, LOGGER)
            ret_list.append(cli_ret)
            # 无法获取原始信息的lun做记录上报
            if cmdRet is not True:
                failed_lun_list.append(lunId)
                continue

            lun_info_list = cliUtil.getVerticalCliRet(cli_ret)
            if not lun_info_list:
                failed_lun_list.append(lunId)
                continue

            lun_info = lun_info_list[0]
            # 如果是未映射的LUN 则跳过
            if lun_info.get("Exposed To Initiator") == 'Yes':
                continue

            # 获取HyperMetro ID(s),以判断是否为双活LUN
            hyper_id = lun_info.get("HyperMetro ID(s)", "")
            # 如果是双活LUN，则记录上报
            if hyper_id != "--" and hyper_id != "" and hyper_id != []:
                hy_lun_list.append(lunId)

    return list(set(hy_lun_list)), list(set(failed_lun_list)), ret_list
