# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
from cbb.frame.cli import cli_with_cache
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    @summary: 双活远程复制大容量LUN配置检查
    """
    allCliRet = ""
    try:
        #获取系统软件版本与热补丁版本
        flag, cliRet, errMsg, softwareVersion, hotPatchVersion = common.getVersion(cli, LANG)
        LOGGER.logInfo("The system software version is %s, hotPatch version is %s" %(softwareVersion, hotPatchVersion))
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, allCliRet, errMsg)

        #检查版本是否为问题版本
        if not isBugVersion(softwareVersion, hotPatchVersion):
            return (True, allCliRet, "")
        
        #获取阵列上262140GB的LUN
        flag, cliRet, errMsg, lunInfoDictList = get262140GBLun(cli)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        #检查262140GB LUN是否配置有双活业务与远程复制业务
        flag, cliRet, errMsg = checkLun(cli, lunInfoDictList, softwareVersion)
        allCliRet = common.joinLines(allCliRet, cliRet)
        return (flag, allCliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def isBugVersion(softwareVersion, hotPatchVersion):
    """
    @summary: 检查设备系统软件版本是否为问题版本
    """
    if softwareVersion not in ["V300R001C00", "V300R001C00SPC100", "V300R001C01", "V300R001C01SPC100"]:
        return False
    
    if softwareVersion in ["V300R001C00", "V300R001C00SPC100"] and hotPatchVersion >= "V300R001C00SPH101":
        return False
    
    return True


def get262140GBLun(cli):
    """
    @summary: 获取大于等于262140GB LUN的ID
    """
    lun_info_list = []
    min_capacity = common.\
        changUnit2GBLabelCapForThreeDecimalDigits('262140GB')
    cmd = "show lun general"
    flag, cli_ret, err_msg = \
        execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli, cmd, LOGGER)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg, []
    
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, cli_ret, "", []
    lun_info_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for lun_info in lun_info_dict_list:
        lun_id = lun_info.get('ID')
        capacity = lun_info.get('Capacity')
        capacity_kb = common.\
            changUnit2GBLabelCapForThreeDecimalDigits(capacity)
        if capacity_kb >= min_capacity:
            lun_info_list.append(lun_id)
    return True, cli_ret, "", lun_info_list

   
def checkLun(cli, lunIdDictList, softwareVersion):
    """
    @summary: 检查lun的双活列表与远程复制列表是否为空
    """
    flag = True
    allCliRet = ""
    errMsg = ""
    
    if not lunIdDictList:
        return (flag, allCliRet, errMsg)
    
    warningLunList = []
    notPassLunList = []
    
    for lun_id in lunIdDictList:
        retFlag, cliRet, retErrMsg, lunInfoDict = getLunInfo(cli, lun_id)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if retFlag != True:
            return (retFlag, allCliRet, retErrMsg)
        
        hyperMetroIDs = lunInfoDict.get("HyperMetro ID(s)")
        remoteReplicationIDs = lunInfoDict.get("Remote Replication ID(s)")
        #已经配置了远程复制活双活业务，检查结果则不通过
        if hyperMetroIDs not in ["", "--"] or remoteReplicationIDs not in ["", "--"]:
            notPassLunList.append(lun_id)
        #未配置远程复制与双活业务，检查结果为建议优化
        else:
            warningLunList.append(lun_id)
    
    if warningLunList:
        flag = cliUtil.RESULT_WARNING
        common.sortListByInt(warningLunList, LOGGER)
        errMsg += common.getMsg(LANG, "lun.262140GB.warning", ",".join(warningLunList))
    
    if notPassLunList:
        flag = False
        #这两个版本还没有针对此问题的解决补丁，用户暂无法处理，检查结果弱化
        if softwareVersion in ["V300R001C01", "V300R001C01SPC100"]:
            flag = cliUtil.RESULT_WARNING
        common.sortListByInt(notPassLunList, LOGGER)
        errMsg += common.getMsg(LANG, "lun.262140GB.notpass", ",".join(notPassLunList))
        
    return (flag, allCliRet, errMsg)


def getLunInfo(cli, lun_id):
    """
    @summary: 获取指定LUN的远程复制ID列表与双活ID列表
    """
    cmd = "show lun general lun_id=%s" % lun_id
    flag, cli_ret, err_msg = cli_with_cache. \
        execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli,
                                           cmd, LOGGER)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg, {}
    
    # 带ID查，必须有数据
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return cliUtil.RESULT_NOCHECK, cli_ret, \
               common.getMsg(LANG, "cannot.get.info", "LUN"), {}

    lunInfoDictList = cliUtil.getVerticalCliRet(cli_ret)
    if not lunInfoDictList:
        return cliUtil.RESULT_NOCHECK, cli_ret, \
               common.getMsg(LANG, "cannot.get.info", "LUN"), {}
    return True, cli_ret, "", lunInfoDictList[0]
