# -*- coding: UTF-8 -*-

import copy

import common
import cliUtil
from container_base_check import ContainerCheck

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

CHECK_URL_LIST = ["inspections/alarms?lang={}".format(LANG)]


def execute(cli):
    """
    数据保护告警信息检查
    """
    result, msg = common.is_support_data_protect_check(PY_JAVA_ENV, cli)
    if msg:
        return cliUtil.RESULT_NOCHECK, "", msg
    if not result:
        return cliUtil.RESULT_NOSUPPORT, "", ""
    dev_node = PY_JAVA_ENV.get("devInfo")
    flag, ips_dict = common.is_need_change_devnode_ip(cli, LOGGER, LANG)
    if flag:
        temp_dev_node = copy.deepcopy(dev_node)
        temp_dev_node.setIp(ips_dict.get("0")[0])
        flag, item_check, msg = _container_check(temp_dev_node)
        ret = deal_unicode("\n".join(item_check.all_cli_ret))
        return flag, ret, msg
    flag, item_check, msg = _container_check(dev_node)
    ret = deal_unicode("\n".join(item_check.all_cli_ret))
    return flag, ret, msg


def deal_unicode(ret):
    try:
        return unicode(ret).decode("unicode-escape")
    except (UnicodeEncodeError, Exception):
        return ret


def _container_check(dev_node):
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, LANG, LOGGER)
    flag, msg = item_check.execute_check()
    return flag, item_check, msg
