# -*- coding: UTF-8 -*-
from __future__ import division
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
            同步远程复制空间预留检查 ； 
            检查步骤：
                步骤1 以admin用户登录设备；
                步骤2 执行命令show remote_replication general，检查是否存在同步远程复制（Replication Mode字段为Synchronous）；
                步骤3 执行命令show storage_pool general，记录所有Pool的总容量（Total Capacity字段值）和空闲容量（Free Capacity字段的值）；
                步骤4 执行show lun general pool_id=POOLID|filterColumn include columnList=ID（剩余容量小于1%的pool），记录pool中LUN LIST；
                步骤5 执行show remote_replication general |filterRow column=Replication\sMode predict=match value=Synchronous |filterColumn include columnList=ID，
                记录同步远程复制ID LIST；
                步骤6 依次检查pool中LUN是否有同步远程复制LUN，执行命令show lun general lun_id=LUNID|filterColumn include columnList=ID,
                Subscribed Capacity,HyperMetro\sID(s),Remote\sReplication\sID(s),Split\sClone\sID(s),Snapshot\sID(s),LUN\sMigration,
                Mirror\sType。如果远程复制Remote Replication字段不为--，且ID值在同步远程复制ID LIST中。
                                         执行记录下LUN ID，pool id和Subscribed Capacity，计算相同pool下的同步复制lun容量总和，检查是否配置有其它特性并做标记。   
            检查标准：
                 注：若存在同步远程复制配置，则远端阵列需要检查该检查项，请添加远端阵列到工具并选择该检查项进行检查。
        1. 若不存在同步远程复制配置则检查通过，否则继续步骤2；
        2. 如果所有Pool均满足：空闲容量（Free Capacity字段的值）大于Pool的总容量（Total Capacity字段值）的1%，则检查通过，否则记录下pool id和Free Capacity；
        3. 如果只有同步远程复制，则使用pool下的同步远程复制LUN容量总和 * 0.005与pool的剩余容量进行比较，如果小于则检查通过，如果大于或者等于则提示用户需要对pool进行扩容；
        4. 如果除了同步远程复制还有其它特性或者同步远程复制有多个ID，则使用pool下的同步远程复制LUN容量总和 * 0.01与pool的剩余容量进行比较，如果小于则检查通过，如果大于或者等于则提示用户需要对pool进行扩容；
    '''
    
    flag = True
    allCliRet = ""
    errMsg = ""
    standard = "0.01"
    
    try:
        #查询是否存在同步远程复制
        flag, cliRet, errMsg, featureExist = isFeatureExist(cli, LANG)
        allCliRet += cliRet
        
        #查询是否存在同步远程复制失败（下发命令失败或发生异常）
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if not featureExist:
            return (True, allCliRet, errMsg)
        
        #检查存储池空闲容量
        flag, cliRet, errMsg, freeCapDict = common.checkPoolFreeCapacity(cli, LANG, standard, LOGGER)
        allCliRet += cliRet
        
        #查询存储池详情失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if not freeCapDict:
            return (True, allCliRet, '')

        #检查增值LUN的总容量是否达标
        flag, cliRet, reachStandrd, errMsg = common.compareFreeCapacity(cli, freeCapDict, 'Remote Replication ID(s)', LANG, py_java_env, LOGGER)        
        allCliRet += cliRet
        #查询LUN信息失败
        if not flag:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if flag != True:
            return (flag, allCliRet, errMsg)
        
        if reachStandrd == False:
            return (False, allCliRet, errMsg)
                       
        return (True, allCliRet, '')
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

    
def isFeatureExist(cli, lang):
    """
    @summary: 执行命令show remote_replication general，
                                    检查是否存在同步远程复制（Replication Mode字段为Synchronous）；
    @return: 
        isSucc：True/False，方法是否正常结束
        cliRet：CLI回显
        errMsg：方法异常结束时的错误消息
        featureExist: True(存在同步远程复制)
                      False(不存在同步远程复制)
    """
    
    isSucc = True
    cliRet = ""
    errMsg = ""
    featureExist = False
    
    try:
        cmd = "show remote_replication general"
        execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRet = execRet[1]
        #命令执行失败
        if execRet[0] == False:
            errMsg = common.getMsg(lang, "can.not.get.replication.info")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg, featureExist)
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            errMsg = cliUtil.getMsg(lang, "has.not.cli.privilege")
            return (cliUtil.RESULT_NOSUPPORT, cliRet, errMsg, featureExist)
        
        if execRet[0] != True:
            return (execRet[0], cliRet, execRet[2], featureExist)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg, featureExist)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        for line in cliRetLinesList:
            repMode = line.get("Replication Mode")
            if repMode == "Synchronous" :
                featureExist = True
                break
                
        return (isSucc, cliRet, errMsg, featureExist)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"), featureExist)
    
