# -*- coding: UTF-8 -*-
import cliUtil
import common
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    远程复制状态检查：
    1 如果远程复制不存在表示正常；
    2 Health Status为Normal表示正常；
    3 其它情况均属于不正常状态。
    :param cli:
    :return:
    """
    cli_ret = ""
    err_msg_list = []

    try:
        cmd = "show remote_replication unified"
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
            py_java_env, cli, cmd, LOGGER
        )

        if flag is not True:
            return flag, cli_ret, err_msg
        if cliUtil.queryResultWithNoRecord(cli_ret):
            return True, cli_ret, err_msg
        ret_line_list = cliUtil.getHorizontalCliRet(cli_ret)
        for line in ret_line_list:
            rep_id = line.get("ID")
            heal_status = line.get("Health Status")
            if heal_status != common.STATUS_NORMAL:
                key = "remote.replication.health.status.abnormal"
                tmp_msg = common.getMsg(LANG, key, (rep_id, heal_status))
                err_msg_list.append(tmp_msg)
                LOGGER.logNoPass(
                    "replication [%s] is abnormal :%s)" % (
                        rep_id, heal_status)
                )
        if err_msg_list:
            return False, cli_ret, "".join(err_msg_list)
        return True, cli_ret, ""
    except Exception as exception:
        LOGGER.logException(exception)
        return (
            cliUtil.RESULT_NOCHECK,
            cli_ret,
            common.getMsg(LANG, "query.result.abnormal"),
        )
