# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException
from config import checking_work_controller_for_lun_copy_version, checking_work_controller_for_lun_copy_model, \
    no_risk_version_and_patch_for_lun_copy
from common import AsynProgress
from cbb.frame.cli import cli_with_cache

PY_JAVA_ENV = py_java_env

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
ALL_ERR_MSG_NO_CHECK = ''
ALL_ERR_MSG_FALSE = ''
standard_value = '2A'


def execute(cli):
    """
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show lun_copy general，查询LUN拷贝配置，记录LUN拷贝ID；
    步骤3 执行命令：show upgrade package，查询是否有大于或等于“2A”的控制器；
    步骤4 执行命令：show lun_copy member lun_copy_id=ID（ID步骤2中查询到的LUN拷贝ID），并记录源LUN ID（第5行的LUN ID）；
    步骤5 执行命令：show lun general lun_id=ID（ID为步骤5中查询到的源LUN ID），并记录Work Controller字段值；
    检查标准：
    1. 若步骤2不存在LUN拷贝配置则通过，否则继续检查；
    2. 若步骤3中存在大于或等于“2A”的控制器，否则继续检查；
    3. 若步骤5中的Work Controller值小于“2A”则检查通过，否则检查不通过；
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    try:
        myPthread.start_thread()
        flag = check_product_info(cli)
        if flag != True:
            if not flag:
                return True, ALL_CLI_RET, ''
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        
        flag = show_package(cli)
        if flag != True:
            return True, ALL_CLI_RET, ''
        
        flag, err_msg, lun_copy_id_list = get_lun_copy(cli)
        if not lun_copy_id_list:
            if flag != True:
                ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK, err_msg)
                return flag, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
            return True, ALL_CLI_RET, ''

        
        origin_lun_id_list = []
        for lun_copy_id in lun_copy_id_list:
            flag, origin_lun_id = get_origin_lun_id(cli, lun_copy_id)
            if flag != True:
                continue
            origin_lun_id_list.append(origin_lun_id)
        if not origin_lun_id_list:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
        work_controller_dict = {}
        for origin_lun_id in origin_lun_id_list:
            flag, work_controller = get_work_controller(cli, origin_lun_id)
            if flag != True:
                continue
            work_controller_dict[origin_lun_id] = work_controller
        if not work_controller_dict:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
        check_result(work_controller_dict)
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')
    else:
        if ALL_ERR_MSG_FALSE:
            return False, ALL_CLI_RET, common.joinLines(ALL_ERR_MSG_FALSE, ALL_ERR_MSG_NO_CHECK)
        if ALL_ERR_MSG_NO_CHECK:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
        return True, ALL_CLI_RET, ''
    finally:
        #停止刷新进度
        myPthread.setStopFlag(True)


def get_lun_copy(cli):
    """
    执行命令：show lun_copy general，查询LUN拷贝配置，记录LUN拷贝ID
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = 'show lun_copy general'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    lun_copy_id_list = []
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, err_msg, lun_copy_id_list
    if flag != True:
        return flag, err_msg, lun_copy_id_list
    cli_ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    for index, cli_ret_dict in enumerate(cli_ret_list):
        lun_copy_id = cli_ret_dict.get('ID', '')
        if not lun_copy_id:
            ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                    common.getMsg(LANG, 'get.lun.copy.id.failed', index + 1))
            continue
        lun_copy_id_list.append(lun_copy_id)
    if lun_copy_id_list:
        return True, '', lun_copy_id_list
    return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, 'query.result.abnormal'), lun_copy_id_list


def show_package(cli):
    """
    执行命令：show upgrade package，查询是否有大于或等于“2A”的控制器；
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, ALL_ERR_MSG_FALSE
    cmd = 'show upgrade package'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    begin_index = cli_ret.find('Software Version')
    end_index = cli_ret.find('HotPatch Version')
    
    checkFlag = False
    info_dict_list = []
    if begin_index != -1 and end_index != -1:
        info_dict_list = cliUtil.getHorizontalCliRet(cli_ret[begin_index: end_index])
    for info_dict in info_dict_list:
        contr_name = info_dict.get('Name', '')
        if contr_name >= standard_value:
            checkFlag = True
    return checkFlag


def get_origin_lun_id(cli, lun_id):
    """
    执行命令：show lun_copy member lun_copy_id=ID（ID步骤2中查询到的LUN拷贝ID），并记录源LUN ID（第5行的LUN ID）
    :param cli:
    :param lun_id:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = 'show lun_copy member lun_copy_id=%s' % lun_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    origin_lun_id = ''
    if flag != True:
        ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                common.getMsg(LANG, 'get.origin.lun.id.failed', (lun_id, err_msg)))
        return cliUtil.RESULT_NOCHECK, origin_lun_id
    cli_ret_lines = cli_ret.splitlines()
    for cli_ret_line in cli_ret_lines:
        if cli_ret_line.strip().startswith('LUN ID'):
            origin_lun_id = cli_ret_line.split(':')[-1].strip()
            break
    if not origin_lun_id:
        ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                common.getMsg(LANG, 'origin.lun.id.not.exist', lun_id))
        return cliUtil.RESULT_NOCHECK, origin_lun_id
    return True, origin_lun_id


def get_work_controller(cli, lun_id):
    """
    执行命令：show lun general lun_id=ID（ID为步骤5中查询到的源LUN ID），并记录Work Controller字段值
    :param cli:
    :param lun_id:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = "show lun general lun_id=%s" % lun_id
    flag, cli_ret, err_msg = cli_with_cache. \
        execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli, cmd,
                                           LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    work_controller = ''
    if flag != True:
        ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                common.getMsg(LANG, 'get.work.controller.failed', (lun_id, err_msg)))
        return cliUtil.RESULT_NOCHECK, work_controller
    cli_ret_list = cliUtil.getVerticalCliRet(cli_ret)
    for cli_ret_dict in cli_ret_list:
        work_controller = cli_ret_dict.get('Work Controller', '')
        if not work_controller:
            ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK,
                                                    common.getMsg(LANG, 'work.controller.not.exist', lun_id))
            return cliUtil.RESULT_NOCHECK, work_controller
    return True, work_controller


def check_result(work_controller_dict):
    """
    若步骤6中的Work Controller值小于“2A”则检查通过，否则检查不通过
    :param work_controller_dict:
    :return:
    """
    global ALL_ERR_MSG_FALSE
    for lun_id, work_controller in work_controller_dict.items():
        if work_controller >= standard_value:
            ALL_ERR_MSG_FALSE = common.joinLines(ALL_ERR_MSG_FALSE,
                                                 common.getMsg(LANG, 'exit.work.controller', (lun_id, work_controller)))


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, software_version, hot_patch_version = common.getVersion(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    if software_version in no_risk_version_and_patch_for_lun_copy:
        no_risk_patch = no_risk_version_and_patch_for_lun_copy.get(software_version, '')
        if hot_patch_version >= no_risk_patch:
            return False
    if software_version in checking_work_controller_for_lun_copy_version and product_model in checking_work_controller_for_lun_copy_model:
        return True
    return cliUtil.RESULT_NOSUPPORT
