
# -*- coding: UTF-8 -*-
import cliUtil
import common
import re

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    绑定端口IP丢失风险检查: 
        1 若设备型号为S2600T/S5500T且系统软件版本为V200R002C20所有版本或设备型号为5300V3/5500V3且系统版本为V300R001C10所有版本，则继续检查；否则检查通过。
        2 若以太网绑定端口的成员端口是在0号槽位（查询”Port ID List“字段的值），检查不通过；否则检查通过。
                    备注：槽位号为“ENG0.A0/B0”表示在0号槽位
    '''

    cliRet = ""
    errMsg = ""
    
    #配置涉及该检查项的的产品软件版本和型号
    isBugProductModelList = ["S2600T", "S5500T", "5300 V3", "5500 V3"]
    isBugProductVersionList = ["V200R002C20.*", "V300R001C10.*"]
    try:
        #获取产品型号和版本
        checkRet = cliUtil.getProductModelWithCliRet(cli, LANG)
        cliRet += checkRet[2]
        if checkRet[0] != True:
            errMsg = checkRet[3]
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：getProductModelWithCliRet返回Fasle是命令执行失败，应该是未检查
            return (checkRet[0], cliRet, errMsg)
        
        productModel = checkRet[1]                    
        #判断是否是问题型号
        if productModel not in isBugProductModelList:
            return (True, cliRet, errMsg)
        
        #获取产品软件版本
        checkRet, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet += "\n" + checkRet[1]
        if checkRet[0] != True:
            errMsg = checkRet[2]
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        checkRet = common.getCurrentVersion(softwareVersionList, LANG)
        if checkRet[0] != True:
            errMsg = checkRet[2]
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, errMsg  # 修改备注：getCurrentVersion返回False是未检查
            return(checkRet[0], cliRet, errMsg)
        
        productVersion = checkRet[1]                      
        #检查当前版本是否存在风险               
        for bugProductVersion in isBugProductVersionList:
            if not re.match(bugProductVersion, productVersion):
                continue

            #执行“show bond_port”
            cmd = "show bond_port"
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRet += "\n" + checkRet[1]
            if checkRet[0] != True: 
                errMsg = checkRet[2]
                LOGGER.logSysAbnormal()
                return (checkRet[0], cliRet, errMsg)        
            
            #判断回显信息是否有效
            if cliUtil.queryResultWithNoRecord(checkRet[1]):
                return (True, cliRet, errMsg)
            
            #判断以太网绑定端口的成员端口是否在0号槽位
            checkRet = isPortIdInSlot0(checkRet[1])
            if not checkRet[0]:
                errMsg += checkRet[1]
                return (checkRet[0], cliRet, errMsg)
                                     
        return (True, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def isPortIdInSlot0(cliRet):
    '''
    @summary: 判断以太网绑定端口的成员端口是否在0号槽位
    @param cliRet: 回显信息
    @return: 
        flag: True不在0号槽位，False在0号槽位
        errMsg:错误信息
    '''
    
    flag = True
    errMsg = ""   
    bondIdDictList = cliUtil.getHorizontalCliRet(cliRet)        
    for bondIdDict in bondIdDictList:
        memberPortIdList = []
        bondId = bondIdDict.get("ID", "--")
        portIdInfo = bondIdDict.get("Port ID List", "--")
        if bondId =="--" and portIdInfo =="--":
            flag = False
            errMsg += common.getMsg(LANG, "can.not.get.bond.info")
            continue
            
        portIdList = portIdInfo.split(",")            
        for memberPortInfo in portIdList:
            memberPortInfoList = memberPortInfo.split(".")
            if len(memberPortInfoList) not in (3, 4):
                flag = False
                errMsg += common.getMsg(LANG, "can.not.get.bond.portId.info", bondId)
                continue               
                
            memberPortSlot = memberPortInfoList[-2]
            if memberPortSlot == "IOM0" or re.match("[A-Za-z]0", memberPortSlot):
                flag = False                                                                                          
                memberPortIdList.append(memberPortInfo) 
                                                                 
        if memberPortIdList:
            errMsg += common.getMsg(LANG, "bond.port.id.in.slot.0",(bondId, ", ".join(memberPortIdList)))
                                   
    return (flag, errMsg)             
                                    
                
