# -*- coding: UTF-8 -*-

import time

import cliUtil
import common
from frameone.util import contextUtil
from frameone.rest import restUtil
from common import UnCheckException
from com.huawei.ism.exception import IsmException
from common_utils import is_super_administrator, is_flush_through_mode
from cbb.frame.util.common import fakeProgress
from cbb.frame.base import baseUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
PERFORMANCE_SWITCH_DISABLED = "83890437"
# 策略被更改的错误码，需等待1分钟重试
PERFORMANCE_POLICY_CHANGED = "83890436"
PERFORMANCE_POLICY_SLEEP_TIME = 60
controller_performance_object = "207"
cache_water_performance_index = "333"

@fakeProgress(py_java_env, totalSeconds=120, logger=LOGGER, interval=1)
def execute(cli):
    """
    cache水位检查
    :param cli:
    :return:
    """

    all_cli_ret = ""
    try:
        product_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        if baseUtil.is_micro_dev(product_model) and is_flush_through_mode(cli, LANG, LOGGER):
            return (cliUtil.RESULT_NOSUPPORT, "System mode: pass-through mode.", "")
        # 不是超级管理员账号,报未完成检查
        if not is_super_administrator(cli, PY_JAVA_ENV.get("devInfoMap").get("userName"), LANG):
            return cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "loginUser.name.level.must.be.super.admin")
        dataDict = contextUtil.getContext(py_java_env)
        rest = contextUtil.getRest(dataDict)
        cache_water = {}
        # 查询控制器信息，或者控制器ID的list
        controller_id_list, all_cli_ret = query_port_info(rest, "controller",
                                                          all_cli_ret, "ID")
        # 查询各个控制器的cache水位
        all_cli_ret = query_performance(rest, controller_id_list,
                                        controller_performance_object,
                                        cache_water_performance_index,
                                        cache_water, all_cli_ret)

        close_rest(rest)

        # 根据检查标准，检查所有所有控制器cache水位
        exceed_80 = []
        exceed_60_less_80 = []
        for key in cache_water:
            perf = cache_water.get(key, '')
            key_perf_msg = "%s: %s%%" % (key, perf)
            if perf.isdigit():
                perf_int = int(perf)
                if perf_int > 80:
                    exceed_80.append(key_perf_msg)
                if perf_int > 60:
                    exceed_60_less_80.append(key_perf_msg)
            else:
                return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                        common.getMsg(
                            LANG,
                            "query.result.controller.cache.water.error",
                            key))

        if exceed_80:
            return False, all_cli_ret, common.getMsg(LANG, "msg.comma").join(
                exceed_60_less_80)

        if exceed_60_less_80:
            return cliUtil.RESULT_WARNING, all_cli_ret, \
                   common.getMsg(LANG, "msg.comma").join(exceed_60_less_80)

        return True, all_cli_ret, ""

    except UnCheckException as unCheckException:
        LOGGER.logInfo(
            "UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet,
                unCheckException.errorMsg)

    except Exception as exception:
        LOGGER.logError("Failed to check coffer :%s" % str(exception))
        return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))


def close_rest(rest):
    try:
        rest.close()
        LOGGER.logInfo("conn close success, close session!")
    except Exception as e:
        LOGGER.logError("conn close except: {}".format(str(e)))


def query_port_info(rest, url, all_cli_ret, id_str):
    """
    根据Res命令，获取对应字段的回文list
    :param rest: rest连接
    :param url: url关键字
    :param all_cli_ret: 所有回文
    :param id_str: 需要获取的信息的字段
    :return: 回文list
    """
    try:
        all_cli_ret = common.joinLines(all_cli_ret,
                                       str(rest.getBaseUri() + url))
        records = restUtil.CommonRestService.get4Big(rest,
                                                     url)
        all_cli_ret = common.joinLines(all_cli_ret, str(records))
    except IsmException as e:
        LOGGER.logError("Query port info error :%s" % str(e))
        raise UnCheckException(
            common.getMsg(LANG, "cannot.build.http.connections"),
            all_cli_ret)

    id_list = []
    for record in records:
        port_id = record.get(id_str, '')
        if port_id:
            id_list.append(port_id)

    return id_list, all_cli_ret


def query_performance(rest, id_list, perf_object, perf_index,
                      cache_water, all_cli_ret):
    """
    根据性能对象和指标，查询对应list的性能数据
    :param rest: rest连接
    :param id_list: 需要查询的id的list
    :param perf_object: 性能对象
    :param perf_index: 性能指标
    :param cache_water: 性能数据liest
    :param all_cli_ret: 原始信息
    :return: 原始信息
    """
    for id in id_list:
        try:
            ret, perf_records = execute_query(rest, perf_object, perf_index, id)
        except IsmException as e:
            if str(e.getErrorId()) == PERFORMANCE_POLICY_CHANGED:
                time.sleep(PERFORMANCE_POLICY_SLEEP_TIME)
                ret, perf_records = execute_query(
                    rest, perf_object, perf_index, id
                )
            if str(e.getErrorId()) == PERFORMANCE_SWITCH_DISABLED:
                raise UnCheckException(
                    common.getMsg(LANG,
                                  "performance.switch.disabled"),
                    all_cli_ret)
            raise UnCheckException(
                common.getMsg(LANG,
                              "query.result.controller.cache.water.error",
                              id), all_cli_ret)
        all_cli_ret = common.joinLines(all_cli_ret, ret)
        all_cli_ret = common.joinLines(all_cli_ret, str(perf_records))
        if len(perf_records) > 0:
            perf = perf_records[0].get("CMO_STATISTIC_DATA_LIST", '')
            if perf:
                cache_water[id] = perf
        else:
            raise UnCheckException(
                common.getMsg(LANG,
                              "query.result.controller.cache.water.error",
                              id), all_cli_ret)
    return all_cli_ret


def execute_query(rest, perf_object, perf_index, obj_id):
    """
    执行命令
    :param rest: rest连接
    :param perf_object: 性能对象
    :param perf_index: 性能指标
    :param obj_id: 需要查询的id的
    :return: 回文，性能记录
    """
    cmdStr = "performace_statistic/cur_statistic_data?" \
             "CMO_STATISTIC_UUID=%s:%s&CMO_STATISTIC_DATA_ID_LIST=%s"
    perf_url = cmdStr % (perf_object, obj_id, perf_index)
    ret = str(rest.getBaseUri() + perf_url)
    perf_records = restUtil.CommonRestService.get4Big(rest,
                                                      perf_url)
    return ret, perf_records