# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        @summary: CIFS share  recommended configuration check
        @return: (status, cliRet, errMsg) 
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    cliRetAll = ""
    try:
        cmd = "show share cifs"
        LOGGER.logExecCmd(cmd)
        echoStatus, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += cliRet
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
        
        if not echoStatus or echoStatus == cliUtil.RESULT_NOSUPPORT or echoStatus == cliUtil.RESULT_NOCHECK :
            #if the command is not supported: 
            LOGGER.logInfo("this device failed in processing cifs command: " + unicode(errMsg))
            
            if "^" in cliRet :
                isQrySuccess, isNasFeatureSupported, errorMsg = common.isNasFeatureSupported(cli, LANG, LOGGER)
                if not isQrySuccess and errorMsg:
                    return  cliUtil.RESULT_NOCHECK, cliRet, errorMsg
                
                if  isQrySuccess and not isNasFeatureSupported :
                    return cliUtil.RESULT_NOSUPPORT, cliRet, "" 
            if isCmdExecutedWithError(cliRet):
                errMsg =  common.getMsg(LANG, "faile.in.fetching.share.cifs.data.all")
                
            if not echoStatus:
                echoStatus = cliUtil.RESULT_NOCHECK
            return echoStatus, cliRet, errMsg
        
        if "successfully" in cliRet.lower():
                return True, cliRetAll, errMsg
        
        cifsInfoMapList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        
        if len(cifsInfoMapList) < 1:
            
            errMsg = common.getMsg(LANG, "faile.in.fetching.share.cifs.data.all")
            LOGGER.logNoPass("Cannot get information of share cifs Id lists")
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        shareCifsIdList = []
        
        for cifsInfoMap in cifsInfoMapList:
            currentCifsShareId = cifsInfoMap.get("Share ID", "")
            if  currentCifsShareId:
                shareCifsIdList.append(currentCifsShareId)
                
        if len(shareCifsIdList) < 1:
            errMsg = common.getMsg(LANG, "faile.in.fetching.share.cifs.data.all")
            LOGGER.logNoPass("Cannot get information of share cifs Id lists")
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        needOptimizedIdLists = []
        isQryFailedIdLists = []
        for shareCifsId in shareCifsIdList:
            cmd = "show share cifs share_id=" + shareCifsId.strip()
            LOGGER.logExecCmd(cmd)
            echoStatus, specificCliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRetLinesList = cliUtil.getVerticalCliRet(specificCliRet)
            cliRetAll += specificCliRet
            if echoStatus == True and len(cliRetLinesList) > 0:
                cifsShareConfigMap = cliRetLinesList[0]
                isNotifyEnabled = cifsShareConfigMap.get("Notify Enabled", "")
                if isNotifyEnabled and isNotifyEnabled.lower() != "enable":
                    needOptimizedIdLists.append(shareCifsId)
            else:
                isQryFailedIdLists.append(shareCifsId)
            
        if needOptimizedIdLists :
            
            errmsg = ""
            if needOptimizedIdLists:
                needOptimizedIds = ""
                for needOptimizedId in needOptimizedIdLists:
                    needOptimizedIds += (", " + needOptimizedId)
                errmsg += common.getMsg(LANG, "following.cifs.share.ids.need.to.be.optimized", needOptimizedIds.lstrip(", "))
                
            if isQryFailedIdLists:
                errmsg += getUncheckItemErrMsg(isQryFailedIdLists) 
            
            return cliUtil.RESULT_WARNING, cliRetAll, errmsg
        
        if isQryFailedIdLists:
            errmsg = getUncheckItemErrMsg(isQryFailedIdLists) 
            return cliUtil.RESULT_NOCHECK, cliRetAll, errmsg
        else :
            LOGGER.logPass()    
            return True, cliRetAll, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))

def getUncheckItemErrMsg(isQryFailedIdLists):
    '''
    @summary: get Msg of unchecked share id items
    '''
    errmsg = ""
    isQryFailedIds = ""
    for isQryFailedId in isQryFailedIdLists:
        isQryFailedIds += (", " + isQryFailedId)
    errmsg = common.getMsg(LANG, "following.cifs.share.ids.failed.to.fetch", isQryFailedIds.lstrip(", ")) 
    return  errmsg       

def isCmdExecutedWithError(cmdEcho):
    '''
    @summary: check whether the command has executed failed
    @return:  True or False
    '''
    if not cmdEcho:
        return False
    for cmdLine in cmdEcho.splitlines():
        if ("error:" in cmdLine.lower() or "error :" in cmdLine.lower()) and "license" not in cmdLine.lower():
            return True
        
    return False