# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET = ''
ALL_FALSE_ERR_MSG = ''
ALL_NO_CHECK_ERR_MSG = ''
EBK_MGR = 'ebk_mgr'
is_no_support = False


def execute(cli):
    """
    步骤1 以admin用户登录设备；
    步骤2 步骤2 执行命令change user_mode current_mode user_mode=developer进入developer模式，执行命令debug进入debug模式；
    步骤3 执行命令ls，查询ebk_mgr的AppID号，并执行命令 attach <AppID>；
    步骤4 执行命令ebk_mgr log_level，查询本控制器cloudbackup日志级别；
    步骤5 minisystem视图下执行sshtoremoteExt x(x = 节点id) 命令，心跳至其他全部节点，分别执行步骤2，3，4。
    检查标准：
    1 步骤4中ebk_mgr log_level命令显示均为Info则为通过，否则不通过。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_FALSE_ERR_MSG, ALL_NO_CHECK_ERR_MSG
    try:
        if not check_product_info(cli):
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        check_ebk_mgr_on_all_nodes(cli)
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')
    else:
        if is_no_support:
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        if ALL_FALSE_ERR_MSG:
            return False, ALL_CLI_RET, common.joinLines(ALL_FALSE_ERR_MSG, ALL_NO_CHECK_ERR_MSG)
        if ALL_NO_CHECK_ERR_MSG:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_NO_CHECK_ERR_MSG
        return True, ALL_CLI_RET, ''
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_ebk_mgr_on_all_nodes(cli):
    """
    心跳至每个控制器去检查ebk_mgr
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_NO_CHECK_ERR_MSG, is_no_support
    # 心跳至每个控制器进行检查
    current_ctrl_node_id, all_other_node_list = get_ctrl_node_info(cli)
    ebk_mgr_appid = get_ebk_mgr_id(cli)
    if ebk_mgr_appid:
        check_ebk_mgr(cli, ebk_mgr_appid, current_ctrl_node_id)
    else:
        is_no_support = True
    for node_id in all_other_node_list:
        flag, cli_ret, err_msg = common.heartBeatToOtherCtrl(cli, node_id, PY_JAVA_ENV, LOGGER, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if flag != True:
            LOGGER.logError('SSH to remote controller failed.')
            ALL_NO_CHECK_ERR_MSG = common.joinLines(ALL_NO_CHECK_ERR_MSG, err_msg)
            continue
        ebk_mgr_appid = get_ebk_mgr_id(cli)
        if ebk_mgr_appid:
            is_no_support = False
            check_ebk_mgr(cli, ebk_mgr_appid, node_id)
        cliUtil.exitHeartbeatCli(cli, LANG)


def get_ctrl_node_info(cli):
    """
    @summary: 获取所有健康节点信息，当前节点信息。
    @param cli: cli连接
    @return:current_ctrl_node_id,all_other_node_list
            current_ctrl_node_id 当前节点ID
            all_other_node_list 除当前节点外其他健康节点信息
    """
    global ALL_CLI_RET
    cmd = 'showsysstatus'
    # 当前节点
    current_ctrl_node_id = None
    all_other_node_list = []

    flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        LOGGER.logInfo('get node info failed.')
        raise UnCheckException(err_msg, ALL_CLI_RET,cliUtil.RESULT_NOCHECK)

    ctrl_info_dict_list = cliUtil.getVerticalCliRet(cli_ret)
    engine_info_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    for ctrl_info in ctrl_info_dict_list:
        if ctrl_info.get('local node id', '') != '':
            current_ctrl_node_id = ctrl_info.get('local node id', '')
            break

    for engine_info in engine_info_dict_list:
        ctrl_node_id = engine_info.get('id', '')
        if ctrl_node_id == '' or ctrl_node_id == current_ctrl_node_id:
            continue
        all_other_node_list.append(ctrl_node_id)
    return current_ctrl_node_id, all_other_node_list


def check_ebk_mgr(cli, app_id, contrl_id):
    """
    执行命令 attach <AppID>
    执行命令ebk_mgr log_level，查询本控制器cloudbackup日志级别
    :param cli:
    :param app_id:
    :param contrl_id:
    :return:
    """
    global ALL_CLI_RET, ALL_FALSE_ERR_MSG, ALL_NO_CHECK_ERR_MSG
    cmd = 'attach %s' % app_id
    _, cli_ret, _ = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    cmd = 'ebk_mgr log_level'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        ALL_NO_CHECK_ERR_MSG = common.joinLines(ALL_NO_CHECK_ERR_MSG, err_msg)
        return
    cli_ret_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    for cli_ret_dict in cli_ret_list:
        ms_name = cli_ret_dict.get('ms_name', '')
        log_level = cli_ret_dict.get('log_level', '')
        if log_level != 'Info':
            ALL_FALSE_ERR_MSG = common.joinLines(ALL_FALSE_ERR_MSG, common.getMsg(LANG, 'ebk.log.level.risk',
                                                                                  (contrl_id, ms_name)))
    return


def get_ebk_mgr_id(cli):
    """
    执行命令change user_mode current_mode user_mode=developer进入developer模式，执行命令debug进入debug模式
    执行命令ls，查询ebk_mgr的AppID号
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_NO_CHECK_ERR_MSG
    cmd = 'ls'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    ebk_mgr_appid = ''
    if flag != True:
        ALL_NO_CHECK_ERR_MSG = common.joinLines(ALL_NO_CHECK_ERR_MSG, err_msg)
        return ebk_mgr_appid
    cli_ret_list = cli_ret.splitlines()
    for cli_ret_line in cli_ret_list:
        if EBK_MGR in cli_ret_line:
            ebk_line = cli_ret_line.strip().split(' ')
            if ebk_line[-1] == EBK_MGR:
                ebk_mgr_appid = ebk_line[0]
                break
    return ebk_mgr_appid


def check_product_info(cli):
    """
    判断产品是否满足检查的版本范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, product_version = common.getProductVersionByUpgradePackage(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    if product_version >= 'V300R002C00SPC100':
        return True
    return False
