# -*- coding: UTF-8 -*-
import cliUtil
import common
from com.huawei.ism.tool.obase.exception import ToolException
import traceback

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
all_cli_ret = ""
exist_patch_version = {"V300R006C50SPC100": "V300R006C50SPH107"}
heal_self_patch_version = {"V300R003C20SPC200": "V300R003C20SPH213"}
SPECIAL_VERSION = "V300R003C20SPC200"
START_VERSION = "V300R006C10"
VALID_FORMAT_MODE = "Disk Extent Mix Format"
VALID_FORMAT_TYPE = "0"


def execute(cli):
    global all_cli_ret
    try:
        # 判断是否需要做检查和是否能够自愈
        flag, is_need_check, is_heal_self, err_msg = check_is_need_check(cli)
        if flag is not True:
            return (flag, all_cli_ret, err_msg)
        if not is_need_check:
            return (True, all_cli_ret, "")
        flag, err_msg = check_disk_domain_format_mode(cli)
        if flag == cliUtil.RESULT_NOCHECK and is_heal_self:
            return (cliUtil.RESULT_WARNING, all_cli_ret, err_msg)
        return (flag, all_cli_ret, err_msg)

    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_disk_domain_format_mode(cli):
    '''
    执行检查
    :return:
    '''
    # 获取硬盘域ID
    flag, disk_domain_id_list, err_msg = get_disk_domain_id_list(cli)
    LOGGER.logInfo("Get disk domain id list is:%s" % disk_domain_id_list)
    if flag is not True:
        return (flag, err_msg)
    # 判断是否存在硬盘域如果不存在，直接通过。
    if len(disk_domain_id_list) == 0:
        return (True, "")
    cli_18000 = None
    try:
        # 如果是18000执行debug命令获取阵列链接
        create_ret = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV,
                                                        LOGGER, LANG)
        if create_ret[0] is not True:
            return cliUtil.RESULT_NOCHECK, create_ret[2]
        cli_18000 = create_ret[1]
        # 检查硬盘域格式化模式是否为混合模式,输出不为混合模式的硬盘域ID列表
        flag, risk_disk_domain_id_list, err_msg = \
            check_is_disk_extent_mix(cli_18000, disk_domain_id_list)
        LOGGER.logInfo(
            "Get risk disk domain id list is:%s" % risk_disk_domain_id_list)
        if flag is not True:
            return (flag, err_msg)
    finally:
        if cli_18000:
            if common.is18000(PY_JAVA_ENV, cli_18000):
                common.closeConnection(cli_18000, PY_JAVA_ENV, LOGGER)
    # 不合规的硬盘域列表不为空则返回不通过
    if risk_disk_domain_id_list:
        return (False,
                common.getMsg(LANG, "disk.domain.format.mode.is.risk",
                              ','.join(risk_disk_domain_id_list)))
    return (True, "")


def check_is_need_check(cli):
    '''
    判断是否需要检查
    :param cli:
    :return:
    '''
    global all_cli_ret
    is_heal_self = False
    flag, product_version, patch_version, cli_ret, err_msg = \
        common.getProductVersionAndHotPatchVersion(
            cli, LOGGER, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    LOGGER.logInfo("Get pruduct version [%s] and patch verison [%s]" % (
        product_version, patch_version))
    if flag is not True:
        return (flag, False, is_heal_self, err_msg)
    if not (
            product_version == SPECIAL_VERSION or
            product_version >= START_VERSION):
        return (True, False, is_heal_self, "")
    if product_version in exist_patch_version:
        need_patch_version = exist_patch_version.get(product_version)
        if patch_version >= need_patch_version:
            return (True, False, is_heal_self, "")
    # 判断是否能够自愈
    if product_version in heal_self_patch_version:
        need_patch_version = heal_self_patch_version.get(product_version)
        if patch_version >= need_patch_version:
            is_heal_self = True

    return (True, True, is_heal_self, "")


def get_disk_domain_id_list(cli):
    '''
    获取硬盘域ID
    :param cli:
    :return:
    '''
    disk_domain_id_list = []
    global all_cli_ret
    cmd = "show disk_domain general |filterColumn include columnList=ID"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True,
                                                              LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, disk_domain_id_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, disk_domain_id_list, "")
    disk_domain_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(disk_domain_info_list) == 0:
        return (cliUtil.RESULT_NOCHECK, disk_domain_info_list,
                common.getMsg(LANG, "query.result.abnormal"))
    for disk_domain_info in disk_domain_info_list:
        disk_domain_id = disk_domain_info.get("ID")
        disk_domain_id_list.append(disk_domain_id)
    return (True, disk_domain_id_list, "")


def check_is_disk_extent_mix(cli, disk_domain_id_list):
    '''
    检查硬盘域格式化模式是否为混合模式,输出不为混合模式的硬盘域ID列表。
    :return:
    '''
    global all_cli_ret
    risk_disk_domain_id_list = []
    for disk_domain_id in disk_domain_id_list:
        # 检查CKG格式化类型（formatType）是否为0
        cmd = "spa dumpobjinfo -p %s -o %s -t 1" % (
            disk_domain_id, disk_domain_id)
        flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, risk_disk_domain_id_list,
                    common.getMsg(LANG, "query.result.abnormal"))
        dump_obj_info_list = cliUtil.getVerticalCliRet(cli_ret)
        if len(dump_obj_info_list) != 1:
            return (cliUtil.RESULT_NOCHECK, risk_disk_domain_id_list,
                    common.getMsg(LANG, "query.result.abnormal"))
        disk_domain_info = dump_obj_info_list[0]
        format_type = disk_domain_info.get("formatType")
        # 如果是合规的CKG格式化类型该硬盘域通过
        if format_type == VALID_FORMAT_TYPE:
            continue

        cmd = "show disk_domain format_mode disk_domain_id=%s" % disk_domain_id
        flag, cli_ret, err_msg = cliUtil.excuteCmdInDeveloper(cli, cmd, True,
                                                              LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return (flag, risk_disk_domain_id_list, err_msg)
        disk_domain_info_list = cliUtil.getVerticalCliRet(cli_ret)
        if len(disk_domain_info_list) != 1:
            return (cliUtil.RESULT_NOCHECK, risk_disk_domain_id_list,
                    common.getMsg(LANG, "query.result.abnormal"))
        disk_domain_info = disk_domain_info_list[0]
        format_mode = disk_domain_info.get("Format Mode")
        if format_mode != VALID_FORMAT_MODE:
            risk_disk_domain_id_list.append(disk_domain_id)
    return (True, risk_disk_domain_id_list, "")
