# -*- coding:utf-8 -*-
# -*- coding:utf-8 -*-
import cliUtil
import common
import traceback
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
ALL_ERR_MSG_FALSE = ''
product_model_list = ['Dorado3000 V3', 'Dorado5000 V3', 'Dorado6000 V3', 'Dorado18000 V3']
standard_value = 8
DAE = 'DAE'
CTE = 'CTE'


def execute(cli):
    """
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show disk_domain general，获取硬盘域信息；
    步骤3 执行命令：show disk general 统计各引擎的硬盘数量。
    检查标准：
    1、如果步骤2已存在硬盘域，则检查通过，否则继续向下检查；
    2、步骤3统计的各引擎Health Status 为Normal状态的硬盘数量，若硬盘数量小于8（匹配框DAExyz或者CTEx，x位置为引擎id），则检查不通过，否则检查通过。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_FALSE
    try:
        if not check_product_info(cli):
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''
        if check_disk_domain(cli):
            return True, ALL_CLI_RET, ''
        engine_disk_dict = get_engine_disk_num(cli)
        check_engine_disk_num(engine_disk_dict)
        if ALL_ERR_MSG_FALSE:
            return False, ALL_CLI_RET, ALL_ERR_MSG_FALSE
        return True, ALL_CLI_RET, ''
    except UnCheckException, un_check_exception:
        LOGGER.logInfo(u'UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(traceback.format_exc())
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')


def check_engine_disk_num(engine_disk_dict):
    """
    检查引擎下的硬盘数量是否小于8
    :param engine_disk_dict:
    :return:
    """
    global ALL_ERR_MSG_FALSE
    if len(engine_disk_dict) == 0:
        ALL_ERR_MSG_FALSE = common.joinLines(ALL_ERR_MSG_FALSE, common.getMsg(LANG, 'disk.num.zero'))
    for engine_id, disk_num in engine_disk_dict.items():
        if disk_num < standard_value:
            ALL_ERR_MSG_FALSE = common.joinLines(ALL_ERR_MSG_FALSE,
                                                 common.getMsg(LANG, 'disk.num.low', (engine_id, disk_num)))


def get_engine_disk_num(cli):
    """
    执行命令：show disk general 统计各引擎的硬盘数量
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    cmd = 'show disk general'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, flag)
    cli_ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    engine_disk_dict = {}
    for cli_ret_dict in cli_ret_list:
        disk_id = cli_ret_dict.get('ID', '')
        disk_health_status = cli_ret_dict.get('Health Status', '')
        if disk_health_status == 'Normal':
            if disk_id.startswith(DAE):
                disk_id_split = disk_id.split(DAE)[-1]
                disk_engine_id = disk_id_split[0] if len(disk_id_split) != 0 else disk_id_split
            elif disk_id.startswith(CTE):
                disk_id_split = disk_id.split(CTE)[-1]
                disk_engine_id = disk_id_split[0] if len(disk_id_split) != 0 else disk_id_split
            else:
                disk_engine_id = ''
            if disk_engine_id:
                if disk_engine_id in engine_disk_dict:
                    engine_disk_dict[disk_engine_id] += 1
                else:
                    engine_disk_dict[disk_engine_id] = 1
    return engine_disk_dict


def check_disk_domain(cli):
    """
    执行命令：show disk_domain general，获取硬盘域信息
    如果已存在硬盘域，则检查通过，否则继续向下检查
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    cmd = 'show disk_domain general'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, flag)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return False
    cli_ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(cli_ret_list) == 0:
        return False
    return True


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, software_version, _ = common.getVersion(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, flag)
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, flag)
    if product_model in product_model_list and software_version >= 'V300R001C00SPC100':
        return True
    return False
