# -*- coding: UTF-8 -*-
import cliUtil
import common
from com.huawei.ism.tool.obase.exception import ToolException
import traceback
import time
import datetime
import re
import config

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

all_cli_ret = ""
# 存储风险列表：[(hostId, 'hostId1,hostId2', portId),]
risky_host_list = []
# 存储主机信息避免重复查询：{hostId:{LUNS_WHERE_HOST_IS_MAPPED_KEY:[lunId1,lunId2..], PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY:[portId1,portId2..], PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY:[portId1,portId2..]}..}
all_host_info = {}
# 全局变量用来存储启动器信息避免重复查询:{wwn:{}}
all_initiator_info = {}
# 作为all_host_info字典中的key值，主机映射的lunId
LUNS_WHERE_HOST_IS_MAPPED_KEY = "LUNS_WHERE_HOST_IS_MAPPED_KEY"
# 作为all_host_info字典中的key值，主机映射的有双活LUN业务的端口列表。
PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY = "PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY"
# 作为all_host_info字典中的key值，主机映射的有LUN业务的端口列表。
PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY = "PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY"
# 当主机映射的mapping_view下没有端口组时，将该标志添加到主机映射的端口列表中，标识该主机可以映射所有端口。
NO_PORT_GROUP_EXISTS_FLAG = "NO_PORT_GROUP_EXISTS_FLAG"
# 启动器的多路径类型
THIRD_PARTY = "Third-party"
# 启动器的故障转移模式
SPECIAL_MODE = "Special Mode"
# 启动器故障转移模式特殊模式的类型
MODE0 = "Mode0"


def execute(cli):
    global all_cli_ret
    err_msg = ""
    try:

        product_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
        product_model = str(common.getProductModeFromContext(PY_JAVA_ENV))
        LOGGER.logInfo("Obtain the product version %s and product model %s." % (product_version, product_model))
        # 检查是否在风险版本内
        if not is_need_check_version(product_model, product_version):
            return (cliUtil.RESULT_NOSUPPORT, "", "")
        # 获取双活lun id
        flag, hyper_metro_lun_id_list, err_msg = get_hyper_metro_lun_id_list(cli)
        LOGGER.logInfo("Get hyper metro lun id is:%s" % hyper_metro_lun_id_list)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        if not hyper_metro_lun_id_list:
            return (True, all_cli_ret, "")
        # 获取装填为link_up的FC端口
        flag, fc_port_in_the_link_up_state_list, err_msg = get_fc_port_in_the_link_up_state_list(cli)
        LOGGER.logInfo("Get fc port in the link_up state list is:%s" % fc_port_in_the_link_up_state_list)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        if not fc_port_in_the_link_up_state_list:
            return (True, all_cli_ret, "")
        return check_the_host_where_the_port_is_mapped(cli, hyper_metro_lun_id_list, fc_port_in_the_link_up_state_list)

    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, all_cli_ret, common.getMsg(LANG, "query.result.abnormal"))


def check_the_host_where_the_port_is_mapped(cli, hyper_metro_lun_id_list, fc_port_in_the_link_up_state_list):
    '''
    :param cli:
    :param hyper_metro_lun_id_list:
    :param fc_port_in_the_link_up_state_list:
    :return:check_result,all_cli_ret, err_msg
    '''
    global all_host_info, risky_host_list
    for fc_port_id in fc_port_in_the_link_up_state_list:
        # 获取当前端口映射的主机及对应的启动器WWN
        flag, host_to_wwn_dict, err_msg = get_host_to_wwn_dict(cli,
                                                               fc_port_id)
        LOGGER.logInfo(
            "Get hosts and initiator wwn where the port is mapped is %s" % host_to_wwn_dict)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        if len(host_to_wwn_dict) <= 1:
            continue
        # 筛选存在LUN的主机
        flag, host_with_luns, err_msg = filter_hosts_with_luns(cli, host_to_wwn_dict)
        LOGGER.logInfo(
            "Get hosts with luns where the port[%s] is mapped is %s" % (fc_port_id, host_with_luns))
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        if not host_with_luns:
            continue
        # 筛选存在双活lun的主机
        hosts_with_hyper_metro_luns = filter_hosts_with_hyper_metro_luns(hyper_metro_lun_id_list, host_with_luns)
        LOGGER.logInfo(
            "Get hosts with hyperMetro luns where the port[%s] is mapped is %s" % (
                fc_port_id, hosts_with_hyper_metro_luns))
        if not hosts_with_hyper_metro_luns:
            continue
        # 筛选启动器满足条件的主机
        flag, hosts_with_the_initiator_problem_conditions, err_msg = filter_hosts_with_the_initiator_problem_conditions(
            cli, hosts_with_hyper_metro_luns, host_to_wwn_dict)
        LOGGER.logInfo(
            "Get hosts with the_initiator problem conditions where the port[%s] is mapped is %s" % (
                fc_port_id, hosts_with_the_initiator_problem_conditions))
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        if not hosts_with_the_initiator_problem_conditions:
            continue
        # 获取存在双活LUN的主机信息(存在双活LUN业务的端口列表，存在业务的端口列表),刷新到all_host_info
        flag, err_msg = get_ports_where_host_with_lun_is_mapped(cli, host_with_luns, hyper_metro_lun_id_list)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
        # 判断启动器满足条件的主机是否与其他主机共用当前端口，记录到risky_host_list
        flag, err_msg = check_whether_host_shares_port_with_other_hosts(cli,
                                                                        hosts_with_the_initiator_problem_conditions,
                                                                        host_with_luns, fc_port_id)
        if flag is not True:
            return (cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg)
    LOGGER.logInfo("Get host info is %s" % all_host_info)
    LOGGER.logInfo("Get risky host is %s" % risky_host_list)
    # 如果没有风险主机返回通过
    if len(risky_host_list) > 0:
        err_msg_list = []
        for risky_host in risky_host_list:
            err_msg = common.getMsg(LANG, "exit.risky.host", risky_host)
            err_msg_list.append(err_msg)
        return (cliUtil.RESULT_WARNING, all_cli_ret, "".join(err_msg_list))
    return (True, all_cli_ret, "")


def is_need_check_version(product_model, product_version):
    '''
    判断是否是需要检查的风险版本,
    :param product_model:
    :param product_version:
    :return:
    '''
    if "dorado" in product_model.lower() and product_version >= "V300R001C01SPC100":
        return True
    if product_version.startswith("V300R003") and product_version >= "V300R003C20":
        return True
    if product_version.startswith("V300R006") and product_version >= "V300R006C00":
        return True
    if product_version.startswith("V500R007") and product_version >= "V500R007C00":
        return True
    return False


def get_hyper_metro_lun_id_list(cli):
    '''
    获取双活LUN的ID
    :param cli:
    :return:
    '''
    global all_cli_ret
    hyper_metro_lun_id_list = []
    cmd = "show hyper_metro_pair general |filterRow column=Type predict=equal_to value=LUN |filterColumn include columnList=Local\sID"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, hyper_metro_lun_id_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, hyper_metro_lun_id_list, "")
    hyper_metro_lun_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if not hyper_metro_lun_info_list:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, hyper_metro_lun_id_list, common.getMsg(LANG, "query.result.abnormal"))
    for hyper_metro_lun_info in hyper_metro_lun_info_list:
        hyper_metro_lun_id = hyper_metro_lun_info.get("Local ID")
        hyper_metro_lun_id_list.append(hyper_metro_lun_id)
    return (True, hyper_metro_lun_id_list, "")


def get_fc_port_in_the_link_up_state_list(cli):
    '''
    获取状态为link_up的FC端口
    :param cli:
    :return:
    '''
    global all_cli_ret
    fc_port_in_the_link_up_state_list = []
    cmd = "show port general physical_type=FC running_status=link_up"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, fc_port_in_the_link_up_state_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, fc_port_in_the_link_up_state_list, "")
    fc_port_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(fc_port_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, fc_port_in_the_link_up_state_list, common.getMsg(LANG, "query.result.abnormal"))
    for fc_port_info in fc_port_info_list:
        fc_port_id = fc_port_info.get("ID")
        fc_port_in_the_link_up_state_list.append(fc_port_id)
    return (True, fc_port_in_the_link_up_state_list, "")


def get_host_to_wwn_dict(cli, fc_port_id):
    '''
    获取FC端口映射的主机及启动器信息
    :param cli:
    :param fc_port_id:
    :return: {host_id:[wwn,wwn1...]}
    '''
    global all_cli_ret
    host_to_wwn_dict = {}
    cmd = "show port initiator port_type=FC port_id=%s" % fc_port_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, host_to_wwn_dict, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, host_to_wwn_dict, "")
    initiator_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(initiator_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, host_to_wwn_dict, common.getMsg(LANG, "query.result.abnormal"))
    for fc_port_info in initiator_info_list:
        host_id = fc_port_info.get("Host ID")
        # 当主机ID为--时不做处理
        if host_id == "--":
            continue
        wwn = fc_port_info.get("WWN")
        if host_id not in host_to_wwn_dict:
            host_to_wwn_dict[host_id] = []
        host_to_wwn_dict.get(host_id).append(wwn)
    return (True, host_to_wwn_dict, "")


def filter_hosts_with_luns(cli, host_to_wwn_dict):
    '''
    筛选存在lun的主机
    :param cli:
    :param host_to_wwn_dict:
    :return:
    '''
    global all_host_info, LUNS_WHERE_HOST_IS_MAPPED_KEY
    hosts_with_luns = []
    for host_id in host_to_wwn_dict.keys():
        if host_id in all_host_info and LUNS_WHERE_HOST_IS_MAPPED_KEY in all_host_info.get(host_id):
            luns_where_host_is_mapped = all_host_info.get(host_id).get(LUNS_WHERE_HOST_IS_MAPPED_KEY)
        else:
            flag, luns_where_host_is_mapped, err_msg = get_luns_where_host_is_mapped(cli, host_id)
            if flag is not True:
                return (cliUtil.RESULT_NOCHECK, hosts_with_luns, err_msg)
        if len(luns_where_host_is_mapped) > 0:
            hosts_with_luns.append(host_id)
    return (True, hosts_with_luns, "")


def get_luns_where_host_is_mapped(cli, host_id):
    '''
    查询主机映射的lun
    :param cli: 
    :param host_id: 
    :return: 
    '''
    global all_cli_ret, all_host_info, LUNS_WHERE_HOST_IS_MAPPED_KEY
    luns_list = []
    if host_id not in all_host_info:
        all_host_info[host_id] = {}
    cmd = "show host lun host_id=%s|filterColumn include columnList=LUN\sID" % host_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, luns_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        # 记录信息到all_host_info中
        all_host_info.get(host_id)[LUNS_WHERE_HOST_IS_MAPPED_KEY] = luns_list
        return (True, luns_list, err_msg)
    lun_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(lun_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, luns_list, common.getMsg(LANG, "query.result.abnormal"))
    for lun_info in lun_info_list:
        lun_id = lun_info.get("LUN ID")
        luns_list.append(lun_id)
    # 记录信息到all_host_info中
    all_host_info.get(host_id)[LUNS_WHERE_HOST_IS_MAPPED_KEY] = luns_list
    return (True, luns_list, "")


def filter_hosts_with_hyper_metro_luns(hyper_metro_lun_id_list, host_with_luns):
    '''
    筛选映射了双活lun的主机
    :param hyper_metro_lun_id_list:
    :param host_with_luns:
    :return:
    '''
    global all_host_info, LUNS_WHERE_HOST_IS_MAPPED_KEY
    hosts_with_hyper_metro_luns = []
    for host_id in host_with_luns:
        luns_where_host_is_mapped = all_host_info.get(host_id).get(LUNS_WHERE_HOST_IS_MAPPED_KEY)
        for luns_id in luns_where_host_is_mapped:
            if luns_id in hyper_metro_lun_id_list:
                hosts_with_hyper_metro_luns.append(host_id)
                break
            else:
                continue
    return hosts_with_hyper_metro_luns


def filter_hosts_with_the_initiator_problem_conditions(cli, hosts_with_hyper_metro_luns,
                                                       host_to_wwn_dict):
    '''
    筛选映射的启动器满足条件的主机列表
    :param cli:
    :param hosts_with_hyper_metro_luns:
    :param host_to_wwn_dict:
    :return:
    '''
    global all_initiator_info
    hosts_with_the_initiator_problem_conditions = []
    for host_id in hosts_with_hyper_metro_luns:
        initiator_wwns = host_to_wwn_dict.get(host_id)
        for wwn in initiator_wwns:
            if wwn in all_initiator_info:
                initiator_info = all_initiator_info.get(wwn)
            else:
                flag, initiator_info, err_msg = get_initiator_info(cli, wwn)
                if flag is not True:
                    return (cliUtil.RESULT_NOCHECK, hosts_with_the_initiator_problem_conditions, err_msg)
            if initiator_info.get("Multipath Type") == "Third-party" and initiator_info.get(
                    "Failover Mode") == "Special Mode" and initiator_info.get("Special Mode Type") == "Mode0":
                hosts_with_the_initiator_problem_conditions.append(host_id)
                break
    return (True, hosts_with_the_initiator_problem_conditions, "")


def get_initiator_info(cli, wwn):
    '''
    获取启动器信息
    :param cli:
    :param wwn:
    :return:
    '''
    global all_cli_ret, all_initiator_info
    initiator_info = {}
    cmd = "show initiator initiator_type=FC wwn=%s" % wwn
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, initiator_info, err_msg)
    initiator_info_list = cliUtil.getVerticalCliRet(cli_ret)
    if len(initiator_info_list) == 0:
        return (False, initiator_info, common.getMsg(LANG, "query.result.abnormal"))
    initiator_info = initiator_info_list[0]
    all_initiator_info[wwn] = initiator_info
    return (True, initiator_info, "")


def get_ports_where_host_with_lun_is_mapped(cli, host_with_luns, hyper_metro_lun_id_list):
    '''
    获取主机信息（映射的存在双活LUN业务的端口列表，映射的存在业务的端口列表），存入all_host_info
    :param cli:
    :param host_with_luns:
    :return:
    '''
    global all_cli_ret, all_host_info, PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY, PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY
    for host_id in host_with_luns:
        if host_id not in all_host_info:
            all_host_info[host_id] = {}
        if PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY in all_host_info.get(
                host_id) and PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY in all_host_info.get(host_id):
            continue
        # 获取主机组ID
        flag, host_group_id_list, err_msg = get_host_group_id(cli, host_id)
        if flag is not True:
            return (flag, err_msg)
        flag, mapping_view_id_list, err_msg = get_mapping_view_id(cli, host_group_id_list)
        if flag is not True:
            return (flag, err_msg)
        flag, err_msg = get_ports_on_mapping_view_to_all_host_info(cli, host_id, mapping_view_id_list,
                                                                   hyper_metro_lun_id_list)
        if flag is not True:
            return (flag, err_msg)
    return (True, "")


def get_host_group_id(cli, host_id):
    '''
    获取主机组ID
    :param cli:
    :param host_id:
    :return:
    '''
    global all_cli_ret
    host_group_id_list = []
    cmd = "show host host_group host_id=%s|filterColumn include columnList=Host\sGroup\sID" % host_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, host_group_id_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, host_group_id_list, "")
    host_group_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(host_group_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, host_group_id_list, common.getMsg(LANG, "query.result.abnormal"))
    for host_group_info in host_group_info_list:
        host_group_id = host_group_info.get("Host Group ID")
        host_group_id_list.append(host_group_id)
    return (True, host_group_id_list, "")


def get_mapping_view_id(cli, host_group_id_list):
    '''
    获取所有主机组对应的mapping_view
    :param cli:
    :param host_group_id_list:
    :return:
    '''
    global all_cli_ret
    mapping_view_id_list = []
    for host_group_id in host_group_id_list:
        cmd = "show host_group mapping_view host_group_id=%s|filterColumn include columnList=Mapping\sView\sID" % host_group_id
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return (flag, mapping_view_id_list, err_msg)
        if cliUtil.queryResultWithNoRecord(cli_ret):
            continue
        mapping_view_info_list = cliUtil.getHorizontalCliRet(cli_ret)
        if len(mapping_view_info_list) == 0:
            LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
            return (False, mapping_view_id_list, common.getMsg(LANG, "query.result.abnormal"))
        for mapping_view_info in mapping_view_info_list:
            mapping_view_id = mapping_view_info.get("Mapping View ID")
            mapping_view_id_list.append(mapping_view_id)
    return (True, mapping_view_id_list, "")


def get_ports_on_mapping_view_to_all_host_info(cli, host_id, mapping_view_id_list, hyper_metro_lun_id_list):
    '''
    筛选符合条件的mapping_viewz中的端口列表（映射的存在双活LUN业务的端口列表，映射的存在业务的端口列表），存入all_host_info
    :param cli:
    :param mapping_view_id_list:
    :return:
    '''
    global all_host_info, PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY, PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY
    ports_that_have_luns_on_the_host = []
    ports_that_have_hyper_metro_luns_on_the_host = []
    if host_id not in all_host_info:
        all_host_info[host_id] = {}
    for mapping_view_id in mapping_view_id_list:
        flag, luns_on_mapping_view_id_list, err_msg = get_luns_on_mapping_view_id(cli, mapping_view_id)
        if flag is not True:
            return (flag, err_msg)
        if len(luns_on_mapping_view_id_list) == 0:
            continue
        flag, ports_on_mapping_view_id_list, is_port_group_exists, err_msg = get_ports_on_mapping_view_id_list(cli,
                                                                                                               mapping_view_id)
        if flag is not True:
            return (flag, err_msg)
        if not is_port_group_exists:
            ports_on_mapping_view_id_list = [NO_PORT_GROUP_EXISTS_FLAG]
        ports_that_have_luns_on_the_host.extend(ports_on_mapping_view_id_list)
        if whether_hyper_metro_luns_exits(luns_on_mapping_view_id_list, hyper_metro_lun_id_list):
            ports_that_have_hyper_metro_luns_on_the_host.extend(ports_on_mapping_view_id_list)
        if NO_PORT_GROUP_EXISTS_FLAG in ports_that_have_luns_on_the_host and NO_PORT_GROUP_EXISTS_FLAG in ports_that_have_hyper_metro_luns_on_the_host:
            break
    all_host_info.get(host_id)[PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY] = ports_that_have_luns_on_the_host
    all_host_info.get(host_id)[
        PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY] = ports_that_have_hyper_metro_luns_on_the_host

    return (True, "")


def get_luns_on_mapping_view_id(cli, mapping_view_id):
    '''
    获取mapping_view映射的lun
    :param cli:
    :param mapping_view_id:
    :return:
    '''
    global all_cli_ret
    luns_on_mapping_view_id_list = []
    cmd = "show mapping_view lun_group mapping_view_id=%s|filterColumn include columnList=LUN\sGroup\sID" % mapping_view_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, luns_on_mapping_view_id_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, luns_on_mapping_view_id_list, "")
    lun_group_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(lun_group_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, luns_on_mapping_view_id_list, common.getMsg(LANG, "query.result.abnormal"))
    lun_group_id = lun_group_info_list[0].get("LUN Group ID")
    cmd = "show lun_group lun lun_group_id=%s|filterColumn include columnList=ID" % lun_group_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, luns_on_mapping_view_id_list, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, luns_on_mapping_view_id_list, "")
    luns_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(luns_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, luns_on_mapping_view_id_list, common.getMsg(LANG, "query.result.abnormal"))
    for lun_info in luns_info_list:
        lun_id = lun_info.get("ID")
        luns_on_mapping_view_id_list.append(lun_id)

    return (True, luns_on_mapping_view_id_list, "")


def get_ports_on_mapping_view_id_list(cli, mapping_view_id):
    '''
    获取获取mapping_view映射的端口
    :return:
    '''
    global all_cli_ret
    ports_on_mapping_view_id_list = []

    # 获取mapping_view映射的端口组
    cmd = "show mapping_view port_group mapping_view_id=%s|filterColumn include columnList=Port\sGroup\sID" % mapping_view_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, ports_on_mapping_view_id_list, False, err_msg)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return (True, ports_on_mapping_view_id_list, False, "")
    port_group_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(port_group_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, ports_on_mapping_view_id_list, False, common.getMsg(LANG, "query.result.abnormal"))
    port_group_id = port_group_info_list[0].get("Port Group ID")

    # 获取端口组下的端口
    cmd = "show port_group port port_group_id=%s port_type=FC" % port_group_id
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return (flag, ports_on_mapping_view_id_list, False, err_msg)
    port_info_list = cliUtil.getHorizontalCliRet(cli_ret)
    if len(port_info_list) == 0:
        LOGGER.logError("Failed to parse the following commands:%s" % str(cli_ret))
        return (False, ports_on_mapping_view_id_list, False, common.getMsg(LANG, "query.result.abnormal"))
    for port_info in port_info_list:
        lun_id = port_info.get("ID")
        ports_on_mapping_view_id_list.append(lun_id)

    return (True, ports_on_mapping_view_id_list, True, "")


def whether_hyper_metro_luns_exits(luns_on_mapping_view_id_list, hyper_metro_lun_id_list):
    '''
    判断luns_on_mapping_view_id_list是否存在双活lun
    :param luns_on_mapping_view_id_list:
    :param hyper_metro_lun_id_list:
    :return:
    '''
    for lun_id in luns_on_mapping_view_id_list:
        if lun_id in hyper_metro_lun_id_list:
            return True
    return False


def check_whether_host_shares_port_with_other_hosts(cli, hosts_with_the_initiator_problem_conditions, host_with_luns,
                                                    fc_port_id):
    '''
    #判断启动器满足条件的主机是否与其他主机共用当前端口，记录到risky_host_list
    :param cli:
    :param hosts_with_the_initiator_problem_conditions:
    :param host_with_luns:
    :return:
    '''
    global all_host_info, PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY, risky_host_list
    for host_id in hosts_with_the_initiator_problem_conditions:
        hosts_share_the_port = []
        host_info = all_host_info.get(host_id)
        if host_info is None:
            LOGGER.logError("Host [%s] info no exits." % host_id)
            return (False, common.getMsg(LANG, "query.result.abnormal"))
        port_that_have_hyper_metro_luns_on_the_host = host_info.get(PORTS_THAT_HAVE_HYPERMETRO_LUNS_ON_THE_HOST_KEY)
        # 如果当前端口不在存在双活LUN业务的端口列表中，并且无端口组标识不在列表中（如果无端口组标识存在则说明主机可以映射到所有端口），则该主机没有映射该端口，继续检查下一个主机。
        if fc_port_id not in port_that_have_hyper_metro_luns_on_the_host and NO_PORT_GROUP_EXISTS_FLAG not in port_that_have_hyper_metro_luns_on_the_host:
            continue
        # 如果风险主机用到了该端口，继续检查其他待业务的主机是否有只用该端口。
        flag, hosts_share_the_port, err_msg = get_hosts_share_the_port(host_with_luns, fc_port_id)
        if flag is not True:
            return (flag, err_msg)
        if host_id in hosts_share_the_port:
            hosts_share_the_port.remove(host_id)
        if len(hosts_share_the_port) != 0:
            risky_host_list.append((host_id, ",".join(hosts_share_the_port), fc_port_id))

    return (True, "")


def get_hosts_share_the_port(host_with_luns, fc_port_id):
    '''
    获取用到FC端口的主机
    :param host_with_luns:
    :param fc_port_id:
    :return:
    '''
    global all_host_info, PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY
    hosts_share_the_port = []
    for host_id in host_with_luns:
        host_info = all_host_info.get(host_id)
        if host_info is None:
            LOGGER.logError("Host [%s] info no exits." % host_id)
            return (False, hosts_share_the_port, common.getMsg(LANG, "query.result.abnormal"))
        port_that_have_luns_on_the_host = host_info.get(PORTS_THAT_HAVE_LUNS_ON_THE_HOST_KEY)
        # 如果当前端口在存在双活LUN业务的端口列表中，或无端口组标识在列表中（如果无端口组标识存在则说明主机可以映射到所有端口），则该主机有映射该端口，加入共用端口的列表。
        if fc_port_id in port_that_have_luns_on_the_host or NO_PORT_GROUP_EXISTS_FLAG in port_that_have_luns_on_the_host:
            hosts_share_the_port.append(host_id)
    return (True, hosts_share_the_port, "")
