# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import funcUtil
import re
from common import AsynProgress
from com.huawei.ism.tool.obase.exception import ToolException
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

# noinspection PyUnresolvedReferences
LANG = common.getLang(py_java_env)
# noinspection PyUnresolvedReferences
LOGGER = common.getLogger(PY_LOGGER, __file__)
# noinspection PyUnresolvedReferences
PY_JAVA_ENV = py_java_env

ALL_CLI_RET_LIST = []
HEART_BEAT_FAILED_NODE_ID_LIST = []
NEED_CHECK_IN_MINISYSTEM_ALL_NODES_LIST = ["0", "1", "2", "3"]
PRODUCT_VERSION = ''
HOT_PATCH_VERSION = ''

RISK_VERSION_DICT = {
    "V300R006C20": "V300R006C20SPH015",
    "V300R006C20SPC100": "V300R006C20SPH115",
    "V500R007C10": "V500R007C10SPH015",
    "V500R007C10SPC100": "V500R007C10SPH115",
    "V500R007C30SPC100": "V500R007C30SPH105",
    "V300R006C50SPC100": "V300R006C50SPH105"
}


def execute(cli):
    """
    检查方法
        步骤1 以admin用户登录设备；
        步骤2 执行命令：show upgrade package，查询版本和补丁信息；
        步骤3 执行命令：show license，查询license信息；
        步骤4 执行命令：show lun general，获取LUN数量及所有LUN的ID；
        步骤5 执行命令：change user_mode current_mode user_mode=developer，
        进入研发模式；
        步骤6 执行命令：debug，进入debug模式；
        步骤7 对步骤4中每一个LUN依次执行命令：devlun showctrl [LUN ID]，
        查询Data Volume ID字段，如果存在Data Volume ID与对应LUN ID不相等的LUN，
        则记录该LUN的ID，并继续检查；
        步骤8 执行命令：sys showcls，查询系统中所有控制器的节点ID和当前节点
        ID信息；如果当前节点ID小于等于3，则执行步骤9-12；否则执行步骤9-10；
        步骤9 针对步骤7记录的每一个LUN依次执行命令：devlun showctrl [LUN ID]，
        查询所有LUN的User LUN Size (Sectors)字段信息值；（因LUN被删除或者其
        他异常，导致无法正常获取LUN的容量信息的，则当前节点该LUN忽略检查）
        步骤10 执行命令：exit，退出debug模式；
        步骤11 执行命令：minisystem，进入小系统模式；
        步骤12 针对步骤7记录的每一个LUN依次执行命令：modifydbtableinfo.sh
        q DB_LUN_S [LUN ID]，查询所有LUN的(Lun:userLunCapacity)字段值和
        (Lun:preUserLunCapacity)字段值；（因LUN被删除或者其他异常，
        导致无法正常获取LUN的容量信息的，则当前节点该LUN忽略检查）
        步骤13 登录当前集群所有节点，分别执行步骤5、6和8。
    检查标准
        1 如果步骤2中系统软件版本小于等于V300R006C10或者V500R007C00、
        大于等于V300R006C60或者V500R007C50，则检查结果为不涉及；
        2 如果步骤3中系统的license信息中，Feature Name字段值不包含
        SmartMigration，则检查结果为不涉及，否则继续检查；
        3 如果步骤7中存在Data Volume ID与对应LUN ID不相等的LUN，则继续检查；
        否则，检查通过（若LUN的数量大于400，则检查结果为建议优化）；
        4 如果任意节点（节点取值范围：0-3）上任一LUN的(Lun:userLunCapacity)
        字段取值与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值不相等，
        则检查不通过；
        5 如果任意节点（节点取值范围：0-3）上任一LUN的(Lun:userLunCapacity)字
        段取值与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值相等，
        且单个控制器（节点取值范围：0-3）上LUN的(Lun:userLunCapacity)字段取值
        和(Lun:preUserLunCapacity)字段取值不相等时查看补丁信息：
        如果版本为V500R007C10且补丁版本小于V500R007C10SPH015则检查结果为不通过，
        否则检查结果为通过（若LUN的数量大于400，则检查结果为建议优化）；
        如果版本为V500R007C10SPC100且补丁版本小于V500R007C10SPH115则检查结果为
        不通过，否则检查结果为通过（若LUN的数量大于400，则检查结果为建议优化）；
        如果版本为V300R006C20且补丁版本小于V300R006C20SPH015则检查结果为不通过，
        否则检查结果为通过（若LUN的数量大于400，则检查结果为建议优化）；
        如果版本为V300R006C20SPC100且补丁版本小于V300R006C20SPH115则检查结果
        为不通过，否则检查结果为通过（若LUN的数量大于400，则检查结果为建议
        优化）；
        其他版本则检查结果为不通过；
        6 如果任意节点（节点取值范围：0-3）上每个LUN的(Lun:userLunCapacity)
        字段取值与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值相等，
        且单个控制器（节点取值范围：0-3）上LUN的(Lun:userLunCapacity)字段取值
        和(Lun:preUserLunCapacity)字段取值相等时，则检查结果为通过
        （若LUN的数量大于400，则检查结果为建议优化）。
    :param cli:
    :return:
    """
    # 如果系统软件版本小于等于V300R006C10或者V500R007C00、大于等于V300R006C60或者V500R007C50
    isRisk, no_support_msg = checkIsRiskVersion(cli)
    LOGGER.logInfo("checkIsRiskVersion isRisk: %s" % isRisk)

    if not isRisk:
        return cliUtil.RESULT_NOSUPPORT, no_support_msg, ""

    is_migration = get_license(cli)
    # 如果步骤3中系统的license信息中不包括SmartMigration，则检查结果为不涉及；
    if not is_migration:
        return cliUtil.RESULT_NOSUPPORT, "\n".join(ALL_CLI_RET_LIST), ""

    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER, sleepTime=8)
    myPthread.start_thread()

    try:
        # 获取全部LUN
        tmpLunIdList = getAllLun(cli)
        lunIdList = tmpLunIdList[0:400]

        if not tmpLunIdList:
            return True, "\n".join(ALL_CLI_RET_LIST), ''

        if common.is18000(PY_JAVA_ENV, cli):
            flag, cliConToCtrl, errMsg = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
            if flag != True:
                return cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST), errMsg

            lunCapInfoDict = checkAllCtrlNode(cliConToCtrl, lunIdList)
            common.closeConnection(cliConToCtrl, PY_JAVA_ENV, LOGGER)
        else:
            lunCapInfoDict = checkAllCtrlNode(cli, lunIdList)

        LOGGER.logInfo("lunCapInfoDict is: %s" % str(lunCapInfoDict))

        nocheckErrMsg = ''
        errMsg = checkLunCapacityConsistence(lunCapInfoDict)

        if HEART_BEAT_FAILED_NODE_ID_LIST:
            nocheckErrMsg = common.getMsg(LANG, "heart.beat.to.node.failed", ",".join(HEART_BEAT_FAILED_NODE_ID_LIST))

        if errMsg:
            return False, "\n".join(ALL_CLI_RET_LIST), errMsg + nocheckErrMsg

        if nocheckErrMsg:
            return cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST), nocheckErrMsg

        if len(tmpLunIdList) > 400:
            return cliUtil.RESULT_WARNING, "\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG,
                                                                                      "check.lun.capacity.consistence.exceeds.400lun.suggession")

        return True, "\n".join(ALL_CLI_RET_LIST), ''

    except common.UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST), unCheckException.errorMsg)
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST),
                common.getMsg(LANG, "query.result.abnormal"))
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, "\n".join(ALL_CLI_RET_LIST), common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        funcUtil.enterUserView(cli, LOGGER)
        myPthread.setStopFlag(True)


def checkIsRiskVersion(cli):
    """
    判断是否是风险版本
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST, PRODUCT_VERSION, HOT_PATCH_VERSION
    flag, PRODUCT_VERSION, HOT_PATCH_VERSION, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(cli, LOGGER,
                                                                                                          LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    # 如果系统软件版本小于等于V300R006C10或者V500R007C00、大于等于V300R006C60或者V500R007C50，则检查结果为不涉及。
    # 此处应该取反向的判断
    risk_map = {"V3": ["V300R006C20", "V300R006C60", "V300R006C10"],
                "V5": ["V500R007C10", "V500R007C50", "V500R007C00"]}
    risk_list = risk_map.get(
        common.get_product_key_by_version(PRODUCT_VERSION), "")
    if not risk_list:
        return False, common.version_no_support_msg_str(
            "", PRODUCT_VERSION, "", "", LANG)
    if checkIsInstalledPath():
        return False, 'Has installed patch {}!'.format(HOT_PATCH_VERSION)
    if risk_list[0] <= PRODUCT_VERSION < risk_list[1]:
        return True, ""
    risky_version_msg = common.getMsg(
        LANG, "msg.more.than") + risk_list[2] + common.getMsg(
        LANG, "msg.comma") + common.getMsg(
        LANG, "msg.less.than") + risk_list[1]
    no_support_msg = common.version_no_support_msg_str(
        "", PRODUCT_VERSION, "", risky_version_msg, LANG)
    return False, no_support_msg


def checkLunCapacityConsistence(lunCapInfoDict):
    """
    LUN的devLunUseLunCap User LUN Size[%s]、Lun:userLunCapacity[%s]和Lun:preUserLunCapacity[%s]的值不相等
    LUN的持久化的配置容量[%s]、LUN的内存中使用容量[%s]、LUN的持久化的临时配置容量[%s]。
    :param lunCapInfoDict:
    :return:
    """
    errMsg = ''
    nodeIdList = lunCapInfoDict.keys()
    # 如果任意节点（节点取值范围：0-3）上每个LUN的(Lun:userLunCapacity)字段取值
    # 与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值不相等
    # 先取出节点0上（如果不存在就顺延）上每个LUN的(Lun:userLunCapacity)字段取值，作为标准取值和其他控制器做比较。
    standardUserLunCapacityDict = {}
    for nodeId in NEED_CHECK_IN_MINISYSTEM_ALL_NODES_LIST:
        isFindAll = True
        lunInfoDictList = lunCapInfoDict.get(nodeId, {})
        for lunId in lunInfoDictList:
            lunInfoDict = lunInfoDictList.get(lunId, {})
            userLunCapacity = lunInfoDict.get("userLunCapacity", "")

            # 如果未找到对应值，则继续在其他节点遍历。
            if not userLunCapacity:
                isFindAll = False
                continue

            if not standardUserLunCapacityDict.get(lunId) and userLunCapacity:
                standardUserLunCapacityDict[lunId] = userLunCapacity

        # 如果在0号节点全部找到就不继续遍历其他节点。
        if isFindAll:
            break

    # 遍历节点做校验
    for nodeId in nodeIdList:
        # 已重启的不通过
        alreadRebootNotPassLunIdList = []

        # 未重启的不通过
        notRebootNotPassLunIdList = []

        lunInfoDictList = lunCapInfoDict.get(nodeId, {})
        for lunId in lunInfoDictList:
            lunInfoDict = lunInfoDictList.get(lunId, {})
            preUserLunCapacity = lunInfoDict.get("preUserLunCapacity", "")
            userLunCapacity = lunInfoDict.get("userLunCapacity", "")
            devLunUseLunCap = lunInfoDict.get("devLunUseLunCap", "")

            # 因LUN被删除或者其他异常，导致无法正常获取LUN的容量信息的，则当前节点该LUN忽略检查。
            if not devLunUseLunCap or not standardUserLunCapacityDict.get(lunId):
                LOGGER.logInfo(
                    "lunId:%s, nodeId:%s, devLunUseLunCap[%s] or standardUserLunCapacity[%s] is not exist, ignor lun check." % (
                        lunId, nodeId, devLunUseLunCap, standardUserLunCapacityDict.get(lunId)))
                continue

            # 两个值不等时，如果任意节点（节点取值范围：0-3）上每个LUN的(Lun:userLunCapacity)字段取值
            # 与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值不相等，则检查不通过。
            # 重启之后的只检查是否不等，需要联系技术工程师处理。
            if devLunUseLunCap != standardUserLunCapacityDict.get(lunId):
                alreadRebootNotPassLunIdList.append(lunId)
                continue

            # 非前4控，无法查询db中的容量数据，
            if nodeId not in NEED_CHECK_IN_MINISYSTEM_ALL_NODES_LIST:
                continue

            # 因LUN被删除或者其他异常，导致无法正常获取LUN的容量信息的，则当前节点该LUN忽略检查。
            if not preUserLunCapacity or not userLunCapacity:
                LOGGER.logInfo(
                    "lunId:%s, nodeId:%s, preUserLunCapacity[%s] or userLunCapacity[%s] is not exist, ignor lun check." % (
                        lunId, nodeId, preUserLunCapacity, userLunCapacity))
                continue

            # 如果任意节点（节点取值范围：0-3）上每个LUN的(Lun:userLunCapacity)字段取值与对应LUN在所有控制器上的User LUN Size (Sectors)字段取值相等，
            # 且单个控制器（节点取值范围：0-3）上LUN的(Lun:userLunCapacity)字段取值和(Lun:preUserLunCapacity)字段取值不相等时查看补丁信息：
            if preUserLunCapacity != userLunCapacity:
                isInstallPatch = checkIsInstalledPath()
                if isInstallPatch:
                    continue

                # 其他版本或未安装补丁时就不通过。
                notRebootNotPassLunIdList.append(lunId)
                continue

        if alreadRebootNotPassLunIdList:
            errMsg += common.getMsg(LANG, "check.lun.capacity.consistence.sectors.not.pass",
                                    (nodeId, ",".join(alreadRebootNotPassLunIdList)))

        if notRebootNotPassLunIdList:
            errMsg += common.getMsg(LANG, "check.lun.capacity.consistence.preuserluncapacity.not.pass",
                                    (nodeId, ",".join(notRebootNotPassLunIdList)))

    return errMsg


def checkIsInstalledPath():
    """
    如果结果为不通过，(Lun:preUserLunCapacity)容量值异常，请安装如下对应版本的补丁，若有疑问请联系技术支持工程师进行处理。
    V300R006C20版本：V300R006C20SPH015；
    V300R006C20SPC100版本：V300R006C20SPH115；
    V500R007C10版本：V500R007C10SPH015；
    V500R007C10SPC100版本：V500R007C10SPH115；
    "V500R007C30SPC100版本": "V500R007C30SPH105",
    "V300R006C50SPC100版本": "V300R006C50SPH105"
    :return:
    """
    return (
            PRODUCT_VERSION in RISK_VERSION_DICT
            and HOT_PATCH_VERSION >= RISK_VERSION_DICT.get(PRODUCT_VERSION)
    )


def checkAllCtrlNode(cli, lunIdList):
    """
    检查所有引擎
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    lunCapInfoDict = {}
    flag, errMsg, cliRet, currentCtrlNodeId, engineCtrlNodeMappingDict, currentEngine, nodeNum = common.getEngineCtrlNodeInfo(
        cli, LOGGER, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    
    if flag != True:
        raise common.UnCheckException(errMsg, cliRet)
    
    # 获取迁移后的LUN。
    migrationLunIdList = getDevLunSectorInDebug(cli, lunIdList, currentCtrlNodeId, {})
    LOGGER.logInfo("Query  migrationLunIdList is:%s." % str(migrationLunIdList))
    if not migrationLunIdList:
        return lunCapInfoDict
    
    
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    
    # 检查当前引擎
    curEngineNodeList = engineCtrlNodeMappingDict.get(currentEngine)
    
    tmpLunCapInfoDict = checkCurrentEngineNodes(curEngineNodeList, cli, migrationLunIdList)
    lunCapInfoDict.update(tmpLunCapInfoDict)

    # 其他引擎
    for engineId in engineCtrlNodeMappingDict:
        # 如果是6控，还需要用到已检查引擎的数据。
        if currentEngine == engineId:
            continue
        curEngineNodeList = engineCtrlNodeMappingDict.get(engineId)

        flag, cliRet, errMsg, jumpConnCli, closeHeartBeatTimes = common.enginesJump(cli, engineId, currentEngine, currentCtrlNodeId, nodeNum,
                                                               PY_JAVA_ENV, LOGGER, LANG, engineCtrlNodeMappingDict)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True:
            raise common.UnCheckException(errMsg, cliRet)
        
        tmpLunCapInfoDict = checkCurrentEngineNodes(curEngineNodeList, jumpConnCli, migrationLunIdList)
        lunCapInfoDict.update(tmpLunCapInfoDict)
        common.enginesBack(jumpConnCli, PY_JAVA_ENV, LOGGER, LANG, closeHeartBeatTimes)

    return lunCapInfoDict


def checkCurrentEngineNodes(curEngineNodeList, cli, migrationLunIdList):
    """
    当前引擎下检查指定的节点。
    :param curEngineNodeList:
    :param cli:
    :return:
    """
    global HEART_BEAT_FAILED_NODE_ID_LIST, ALL_CLI_RET_LIST
    lunCapInfoDict = {}
    __, __, __, currentCtrlNodeId, __, __, __ = common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)

    # 默认都需要进debug查User LUN Size(Sectors)
    getDevLunSectorInDebug(cli, migrationLunIdList, currentCtrlNodeId, lunCapInfoDict)
    curEngineNodeList.remove(currentCtrlNodeId)
    
    # 检查当前节点
    if currentCtrlNodeId in NEED_CHECK_IN_MINISYSTEM_ALL_NODES_LIST:
        queryPreUserLunCapacityInMinisystem(cli, migrationLunIdList, currentCtrlNodeId, lunCapInfoDict)
        LOGGER.logInfo("queryPreUserLunCapacityInMinisystem lunCapInfoDict:%s." % str(lunCapInfoDict))

    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    
    # 检查其他节点
    for contrNodeId in curEngineNodeList:
        flag, cliRet, errMsg = common.heartBeatToOtherCtrl(cli, contrNodeId, PY_JAVA_ENV, LOGGER, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True:
            HEART_BEAT_FAILED_NODE_ID_LIST.append(contrNodeId)
            continue

        # 默认都需要进debug查User LUN Size(Sectors)
        getDevLunSectorInDebug(cli, migrationLunIdList, contrNodeId, lunCapInfoDict)
        LOGGER.logInfo("getDevLunSectorInDebug lunCapInfoDict:%s." % str(lunCapInfoDict))
        
        # 前4个节点 需要查db，进minisystem
        if contrNodeId in NEED_CHECK_IN_MINISYSTEM_ALL_NODES_LIST:
            queryPreUserLunCapacityInMinisystem(cli, migrationLunIdList, contrNodeId, lunCapInfoDict)
            LOGGER.logInfo("queryPreUserLunCapacityInMinisystem lunCapInfoDict:%s." % str(lunCapInfoDict))

        cliUtil.exitHeartbeatCli(cli, LANG)
        LOGGER.logInfo("exit heart beat success.")

    return lunCapInfoDict


def queryPreUserLunCapacityInMinisystem(cli, lunIdList, nodeId, lunCapInfoDict):
    """
    查询
    :param cli:
    :param lunIdList:
    :return:
    """
    global ALL_CLI_RET_LIST
    cliUtil.enterCliModeFromSomeModel(cli, LANG)
    flag, cliRet, errMsg = cliUtil.enterDeveloperMode(cli, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if flag!= True:
        raise common.UnCheckException(errMsg, "\n".join(ALL_CLI_RET_LIST))

    flag, cliRet, errMsg = cliUtil.enterMinisystemModeFromDevelopModel(cli, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    if not flag:
        raise common.UnCheckException(errMsg, "\n".join(ALL_CLI_RET_LIST))

    regxPreUseLunCap = re.compile(r"\(Lun:preUserLunCapacity\)\s*=\s*(\S*)")
    regxUseLunCap = re.compile(r"\(Lun:userLunCapacity\)\s*=\s*(\S*)")
    for lunId in lunIdList:
        cmd = "modifydbtableinfo.sh q DB_LUN_S %s" % lunId
        flag, cliRet, errMsg = cliUtil.excuteModifydbtableinfoInMinisystemModel(cli, cmd, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag!= True:
            continue

        retListPreUseCap = regxPreUseLunCap.findall(cliRet)
        retListUseCap = regxUseLunCap.findall(cliRet)
        if not retListPreUseCap or not retListUseCap:
            continue

        tmpDict = lunCapInfoDict.get(nodeId, {})
        tmpDict2 = tmpDict.get(lunId, {})
        tmpDict2["preUserLunCapacity"] = retListPreUseCap[0]
        tmpDict2["userLunCapacity"] = retListUseCap[0]
        tmpDict[lunId] = tmpDict2
        lunCapInfoDict[nodeId] = tmpDict



def hex2dec(string_num):
    """
        十六进制 to 十进制
    """
    try:
        return str(int(string_num.upper(), 16))
    except:
        LOGGER.logError(str(traceback.format_exc()))
    return string_num


def getDevLunSectorInDebug(cli, lunIdList, nodeId, lunCapInfoDict):
    """
    获取devLun在内存中的使用大小
    User LUN Size (Sectors)                           : 10485760
    :param cli:
    :param lunIdList:
    :param nodeId:
    :param lunCapInfoDict:
    :return:
    """
    global ALL_CLI_RET_LIST
    migrationLunIdList = []
    for lunId in lunIdList:
        cmd = "devlun showctrl %s" % lunId
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        ALL_CLI_RET_LIST.append(cliRet)
        if flag != True:
            continue
        
        valumeIdRegx = re.compile(r"Data Volume ID\s*:\s*(\S*)")
        valumeIdList = valumeIdRegx.findall(cliRet)
        if not valumeIdList:
            LOGGER.logInfo("getDevLunSectorInDebug valumeIdList not exist, ignore lun:%s." % lunId)
            continue
        
        if hex2dec(valumeIdList[0]) != lunId:
            migrationLunIdList.append(lunId)
        
        regxUseLunCap = re.compile(r"User LUN Size \(Sectors\)\s*:\s*(\S*)")
        retListUseCap = regxUseLunCap.findall(cliRet)

        # 因LUN被删除或者其他异常，导致无法正常获取LUN的容量信息的，则当前节点该LUN忽略检查。
        if not retListUseCap:
            LOGGER.logInfo("getDevLunSectorInDebug retListUseCap not exist, ignore lun:%s." % lunId)
            continue

        lunInfoDict = lunCapInfoDict.get(nodeId, {})
        tmpDict = lunInfoDict.get(lunId, {})
        tmpDict["devLunUseLunCap"] = retListUseCap[0]
        lunInfoDict[lunId] = tmpDict
        lunCapInfoDict[nodeId] = lunInfoDict

    return migrationLunIdList


def get_license(cli):
    '''
    获取当前阵列license
    :param cli:
    :return:系统的license信息中不包括SmartMigration，则检查结果为不涉及；
    '''
    global ALL_CLI_RET_LIST
    cmd = "show license"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET_LIST.append(cliRet)
    LOGGER.logInfo(
        "flag in license:%s." % flag)
    # 如果license不存在，则不涉
    if flag == cliUtil.RESULT_NOSUPPORT:
        return False
    # 如果命令执行失败，则继续检查
    if flag is not True:
        return True
    for line in cliRet.splitlines():
        if "SmartMigration" in line and "Feature Name" in line:
            return True
    return False

def getAllLun(cli):
    """
    获取全部LUN ID
    :param cli:
    :return:
    """
    global ALL_CLI_RET_LIST
    lun_id_list = []
    cmd = "show lun general"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        PY_JAVA_ENV, cli, cmd, LOGGER)
    ALL_CLI_RET_LIST.append(cli_ret)
    if flag is not True:
        raise common.UnCheckException(err_msg, "\n".join(ALL_CLI_RET_LIST))

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return lun_id_list

    cli_ret_lines_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    for lunInfo in cli_ret_lines_list:
        lun_id = lunInfo.get("ID")
        if not lun_id:
            continue

        lun_id_list.append(lun_id)

    return lun_id_list
