# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import traceback
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""


def execute(cli):
    """
    成员盘列表检查
    """
    global ALL_CLI_RET
    try:
        # 检查是否风险版本
        isRisk = checkIsRiskVersion(cli)
        LOGGER.logInfo("is risk: %s" % isRisk)
        if not isRisk:
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''

        # 获取engine id
        engineDict = getEngineList(cli)
        LOGGER.logInfo("engineDict is: %s" % engineDict)
        faultComponentList, offLineComponentList = checkComponentNormal(engineDict)
        if faultComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.engine.fault", ",".join(faultComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
        if offLineComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.engine.offine", ",".join(offLineComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

        # 获取所以控制器信息
        controllerDict = getAllControllerList(cli)
        LOGGER.logInfo("controllerDict is: %s" % controllerDict)

        faultComponentList, offLineComponentList = checkComponentNormal(controllerDict)
        if faultComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.controller.fault", ",".join(faultComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
        if offLineComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.controller.offine", ",".join(offLineComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

        # 获取domain信息
        domainDict = getDomainList(cli)
        LOGGER.logInfo("domainDict is: %s" % domainDict)
        if not domainDict:
            return True, ALL_CLI_RET, ""
        faultComponentList, offLineComponentList = checkComponentNormal(domainDict)
        if faultComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.domain.fault", ",".join(faultComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
        if offLineComponentList:
            errMsg = common.getMsg(LANG, "member.disk.list.domain.offine", ",".join(offLineComponentList))
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

        # 进developer
        flag, cliRet, errMsg = cliUtil.enterDeveloperMode(cli, LANG)
        if flag != True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

        for engineId in engineDict:
            blockManagerDict = {}
            controllerList = [controllerId for controllerId in controllerDict if
                              engineId in controllerDict[controllerId].get("localtionId", "")]

            if len(controllerList) == 1:
                errMsg = common.getMsg(LANG, "member.disk.list.only.one.controller", engineId)
                return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

            for poolId in domainDict:
                for controllerId in controllerList:
                    getBlockManagerList(cli, poolId, controllerId, blockManagerDict)
            
            if not blockManagerDict:
                continue
            
            LOGGER.logInfo("blockManagerDict is: %s" % blockManagerDict)
            comparedCtrlList = []
            for controllerId in controllerList:
                if controllerId in comparedCtrlList:
                    continue

                ctrlPairId = config.CONTROLLER_PAIR_DORADO.get(controllerId)
                diskNum1 = blockManagerDict.get(controllerId, {}).get("configDiskNum", 0)
                diskNum2 = blockManagerDict.get(ctrlPairId, {}).get("configDiskNum", 0)
                if diskNum1 != diskNum2:
                    errMsg += common.getMsg(LANG, "member.disk.list.controller.disk.num",
                                            (engineId, controllerId, ctrlPairId))
                
                ctrlDickList1 = blockManagerDict.get(controllerId, {}).get("configDickList", "")
                ctrlDickList2 = blockManagerDict.get(ctrlPairId, {}).get("configDickList", "")
                dickList1 = ctrlDickList1.split(" ")
                dickList2 = ctrlDickList2.split(" ")
                diffList1 = [i for i in dickList1 if i not in dickList2]
                diffList2 = [i for i in dickList2 if i not in dickList1]
                
                if len(dickList1) != len(dickList2) or len(diffList1) > 0 or len(diffList2) > 0:
                    errMsg += common.getMsg(LANG, "member.disk.list.controller.disk.list",
                                        (engineId, controllerId, ctrlPairId))
                
                if int(diskNum1) != len(dickList1):
                    errMsg += common.getMsg(LANG, "member.disk.list.controller.disk.list.and.num",
                                        (engineId, controllerId))
                    
                if int(diskNum2) != len(dickList2):
                    errMsg += common.getMsg(LANG, "member.disk.list.controller.disk.list.and.num",
                                        (engineId, ctrlPairId))
                
                comparedCtrlList.append(ctrlPairId)
                comparedCtrlList.append(controllerId)

        if errMsg:
            return False, ALL_CLI_RET, errMsg

        return True, ALL_CLI_RET, errMsg

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkComponentNormal(componentDict):
    """
    检查组件健康状态和运行状态是否正常。
    """
    faultComponentList = [id for id in componentDict if componentDict[id].get("healthStatus") != "Normal"]
    offLineComponentList = [id for id in componentDict if componentDict[id].get("runningStatus") != "Online"]
    return faultComponentList, offLineComponentList


def getBlockManagerList(cli, poolId, controllerId, blockManagerDict):
    """
    查询成员盘信息
    """
    global ALL_CLI_RET
    cmd = "show block_manager block_manager_object disk_pool_id=%s controller=%s" % (poolId, controllerId)
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    blockManagerInfoList = cliUtil.getVerticalCliRet(cliRet)
    for blockManagerInfo in blockManagerInfoList:
        configDiskNum = blockManagerInfo.get("Config Disk Num", "")
        configDickList = blockManagerInfo.get("Config Disk List")
        if not configDiskNum.isdigit():
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "Config Disk Num"), ALL_CLI_RET)
        if configDiskNum and configDickList:
            blockManagerDict[controllerId] = {"configDiskNum": configDiskNum,
                                              "configDickList": configDickList}


def getDomainList(cli):
    """
    查询domain信息
    """
    global ALL_CLI_RET
    cmd = "show disk_domain general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    domainDict = {}
    domainInfoList = cliUtil.getHorizontalCliRet(cliRet)
    for domainInfo in domainInfoList:
        domainId = domainInfo.get("ID")
        healthStatus = domainInfo.get("Health Status")
        runningStatus = domainInfo.get("Running Status")

        domainDict[domainId] = {"healthStatus": healthStatus,
                                "runningStatus": runningStatus
                                }
    return domainDict


def getAllControllerList(cli):
    """
    查询控制器信息
    """
    global ALL_CLI_RET
    cmd = "show controller general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    controllerDict = {}
    controllerInfoList = cliUtil.getVerticalCliRet(cliRet)
    for controllerInfo in controllerInfoList:
        controllerId = controllerInfo.get("Controller")
        localtionId = controllerInfo.get("Location")
        healthStatus = controllerInfo.get("Health Status")
        runningStatus = controllerInfo.get("Running Status")
        controllerDict[controllerId] = {"localtionId": localtionId,
                                        "healthStatus": healthStatus,
                                        "runningStatus": runningStatus
                                        }

    return controllerDict


def getEngineList(cli):
    """
    查询引擎信息
    """
    global ALL_CLI_RET
    cmd = "show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    engineDict = {}
    engineInfoList = cliUtil.getHorizontalCliRet(cliRet)
    for engineInfo in engineInfoList:
        engineId = engineInfo.get("ID")
        healthStatus = engineInfo.get("Health Status")
        runningStatus = engineInfo.get("Running Status")
        engineDict[engineId] = {"healthStatus": healthStatus,
                                "runningStatus": runningStatus
                                }
    return engineDict


def checkIsRiskVersion(cli):
    """
    是否风险版本
    """
    currentVersion = getCurrentVersion(cli)
    if currentVersion in config.MEMBER_DISK_LIST_PRODUCT_VERSION:
        return True
    return False


def getCurrentVersion(cli):
    """
    查询版本信息
    """
    global ALL_CLI_RET
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    softwareVersionIndex = cliRet.find("Software Version")
    hotPatchVersionIndex = cliRet.find("HotPatch Version")

    softwareVersionList = cliUtil.getHorizontalCliRet(cliRet[softwareVersionIndex:hotPatchVersionIndex])
    for version in softwareVersionList:
        LOGGER.logInfo("getCurrentVersion :%s" % str(version.get("Current Version")))
        return str(version.get("Current Version"))
