# -*- coding: UTF-8 -*-
import cliUtil
import common
import re
import os
import traceback
import time
import shutil
from event_log_util import fetchEventLog2Local
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache
from common import UnCheckException
from cbb.frame.context import contextUtil
import common_utils

ALL_CLI_RET = ''
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    启动器多路径类型配置检查
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    err_msg = ""

    conn = ""
    try:
        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        if contextUtil.is_run_in_svp() and \
                common_utils.can_enter_debug_mode_for_read_only_user(cli, LANG,
                                                                     LOGGER):
            flag, conn, err_msg = common. \
                createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
            cli = conn if flag else cli

        host_id_list = check_third_part_mutipath_risk(cli)
        LOGGER.logInfo("get event host id success:{}".format(host_id_list))
        # 为default的主机
        host_default_list = list()
        # 为host_Third_party的主机
        host_third_party_list = list()
        # 有问题的主机
        err_host_map = dict()
        host_default_list, host_third_party_list = get_fc_iscsi_initiator_cache(
            cli, host_default_list, host_third_party_list)
        common.refreshProcess(PY_JAVA_ENV, 80, LOGGER)
        default_err_host = [host_id for host_id in host_default_list if host_id in host_id_list]
        third_part_err_host = [host_id for host_id in host_third_party_list if host_id not in host_id_list]
        if default_err_host:
            err_msg += common.getMsg(
                LANG, "if_software_multipath_check.notpass.default", ", ".join(default_err_host))
        if third_part_err_host:
            err_msg += common.getMsg(
                LANG, "if_software_multipath_check.notpass.thridpart", ", ".join(third_part_err_host))
        if err_msg:
            # 开局巡检为建议优化，日常巡检为不通过
            result_status = cliUtil.RESULT_WARNING if common.is_opening_delivery_inspect(PY_JAVA_ENV) else False
            return result_status, ALL_CLI_RET, err_msg
        return True, ALL_CLI_RET, err_msg
    except common.UnCheckException as unCheckException:
        errMsg = unCheckException.errorMsg
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(
            LANG, "query.result.abnormal")
    finally:
        if cli is conn:
            common.closeConnection(cli, PY_JAVA_ENV, LOGGER)


def check_third_part_mutipath_risk(cli):
    """
    @summary: 检查是否使用了第三方多路径做双活
    @return: flag, isRiskFlag, cliEchos, errMsg
        isRiskFlag True: 有风险
                   False: 无风险
    """
    # 检查是否有多路径未推送的事件
    hostIdList, isAlarmEventBeUsedUp = checkMutiPathExceptHosts(cli)
    common.refreshProcess(PY_JAVA_ENV, 40, LOGGER)
    LOGGER.logInfo(
        "found push exception event hostId Lists as:%s" % str(hostIdList))
    if isAlarmEventBeUsedUp:
        LOGGER.logInfo(
            "There is an alarm indicating that the event storage "
            "space is about to reach the upper limit. Event "
            "0x100f0015001c may be overwritten. Contact technical "
            "engineers.")
    return hostIdList


def checkMutiPathExceptHosts(cli):
    """
    @summary: 检查是否有多路径未推送的事件
    @return hostIdList
        hostIdList: 事件中host的Id
    """
    global ALL_CLI_RET
    common.refreshProcess(PY_JAVA_ENV, 10, LOGGER)
    hostIdList = []
    isAlarmEventBeUsedUp = False
    resultStatus, logLocation, errMsg = fetchEventLog2Local(PY_JAVA_ENV, cli,
                                                            LOGGER, LANG)
    if resultStatus is not True:
        # 由于局点出现下载失败的情况，增加一次重试。
        LOGGER.logInfo(
            "fetchEventLog2Local resultStatus:{}. 40S"
            " later will retry.".format(resultStatus))
        for i in range(15, 25):
            time.sleep(4)
            common.refreshProcess(PY_JAVA_ENV, i, LOGGER)
        LOGGER.logInfo("fetchEventLog2Local start retry.")
        resultStatus, logLocation, errMsg = fetchEventLog2Local(PY_JAVA_ENV,
                                                                cli, LOGGER,
                                                                LANG)
        LOGGER.logInfo(
            "fetchEventLog2Local retry end. the status:{}".format(
                resultStatus))
        if resultStatus is not True:
            raise UnCheckException(errMsg, ALL_CLI_RET)
    common.refreshProcess(PY_JAVA_ENV, 30, LOGGER)
    sevenZipEngine = PY_JAVA_ENV.get("extraMap")
    deCompressCmds = ['xxx', 'xxx']
    deCompressDestDir = sevenZipEngine.deCompressPackage(logLocation,
                                                         deCompressCmds)
    LOGGER.logInfo("Decompress event log to directory: " + deCompressDestDir)
    if not (os.path.exists(deCompressDestDir) and os.path.isdir(
            deCompressDestDir)):
        errMsg = common.getMsg(LANG, "failed.decompress.event.log")
        raise UnCheckException(errMsg, ALL_CLI_RET)
    logFiles = []
    for fpath, dirs, files in os.walk(deCompressDestDir):
        for singlefile in files:
            canoPath = os.path.join(fpath, singlefile)
            if not os.path.isdir(canoPath):
                logFiles.append(canoPath)
    LOGGER.logInfo("Now start to analysis log files listed as: {}".format(
        ",".join(logFiles)))
    for curFile in logFiles:
        fileObj = None
        try:
            fileObj = open(curFile, 'r')
            for line in fileObj:
                if "0xF00310004" in line:
                    isAlarmEventBeUsedUp = True

                if '0x100F0015001C' in line or '0x100F0015003B' in line:
                    searchRes = re.search(r"(ID\s+\d+)", line)
                    if searchRes:
                        hostIdStr = searchRes.group().lstrip("ID").strip()
                        hostIdList.append(hostIdStr)
        except Exception as exception:
            LOGGER.logError("failed to open file.{}".format(
                exception))
        finally:
            if fileObj:
                fileObj.close()
    try:
        baseLocation = deCompressDestDir[:deCompressDestDir.rfind(os.sep)]
        LOGGER.logInfo("clear temp files located: {}".format(baseLocation))
        shutil.rmtree(baseLocation)
    except:
        LOGGER.logError("failed to clear local temp directory, quit.{}".format(
            traceback.format_exc()))

    return list(set(hostIdList)), isAlarmEventBeUsedUp


def get_host_with_initiator(initiator_list, host_default_list,
                            host_third_party_list):
    """
    获取主机启动器多路径类型
    """
    for initiator in initiator_list:
        host_id = initiator.get("Host ID", "")
        multipath_type = initiator.get("Multipath Type", "")
        if not host_id or not multipath_type or host_id == "--":
            continue
        if multipath_type == 'Default':
            host_default_list.append(host_id)
        if multipath_type == 'Third-party':
            host_third_party_list.append(host_id)
    return host_default_list, host_third_party_list


def get_fc_iscsi_initiator_cache(cli, host_default_list,
                                 host_third_party_list):
    """
    获取FC和ISCSI启动器信息
    :param env: 上下文
    :param cli: 连接
    :param logger: 日志
    :return: cli_ret, fc_dict_list, iscsi_dict_list
    """
    global ALL_CLI_RET

    fc_dict_list = []
    iscsi_dict_list = []
    cmd = "show initiator"
    flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
        PY_JAVA_ENV, cli, cmd, LOGGER)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)

    if flag is not True:
        LOGGER.logException("execute cmd error: {}.".format(cli_ret))
        raise UnCheckException(err_msg, ALL_CLI_RET)

    if cliUtil.queryResultWithNoRecord(cli_ret):
        return host_default_list, host_third_party_list

    fc_cli_ret = cli_ret[:cli_ret.find("iSCSI IQN")]
    iscsi_cli_ret = cli_ret[cli_ret.find("iSCSI IQN") - 2:]

    fc_dict_list = cliUtil.getHorizontalCliRet(fc_cli_ret)
    host_default_list, host_third_party_list = get_host_with_initiator(
        fc_dict_list, host_default_list,
        host_third_party_list)
    iscsi_dict_list = cliUtil.getHorizontalCliRet(iscsi_cli_ret)
    host_default_list, host_third_party_list = get_host_with_initiator(
        iscsi_dict_list, host_default_list,
        host_third_party_list)

    return host_default_list, host_third_party_list
