# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        @summary: NDMP recommended configuration check
        @return: (status, cliRet, errMsg)
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
        cmd = "show service ndmp"
        LOGGER.logExecCmd(cmd)
        echoStatus, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        echoMap = {}
        
        if not cliUtil.hasCliExecPrivilege(cliRet):
            return (cliUtil.RESULT_NOSUPPORT, cliRet, "")

        if not echoStatus or echoStatus == cliUtil.RESULT_NOSUPPORT or echoStatus == cliUtil.RESULT_NOCHECK :
            #if the command is not supported: 
            LOGGER.logInfo("this device failed in processing ndmp command: " + unicode(errMsg))
            
            if "^" in cliRet :
                isQrySuccess, isNasFeatureSupported, errorMsg = common.isNasFeatureSupported(cli, LANG, LOGGER)
                if not isQrySuccess and errorMsg:
                    return  cliUtil.RESULT_NOCHECK, cliRet, errorMsg
                
                if  isQrySuccess and not isNasFeatureSupported :
                    return cliUtil.RESULT_NOSUPPORT, cliRet, "" 
            if isCmdExecutedWithError(cliRet):
                errMsg = common.getMsg(LANG, "parse.ndpm.service.configuration.failed")
                
            if not echoStatus:
                echoStatus = cliUtil.RESULT_NOCHECK
            return echoStatus, cliRet, errMsg
        
        if "successfully" in cliRet.lower():
                return True, cliRet, errMsg

        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        
        if len(cliRetLinesList) < 1:
            
            errMsg = common.getMsg(LANG, "parse.ndpm.service.configuration.failed")
            LOGGER.logNoPass("Cannot get information of ndmp service settings")
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        
        echoMap = cliRetLinesList[0]
        
        ipV4 = echoMap.get("IP", "")
        isSnapShotSupport = echoMap.get("Support Snapshot", "")
        isCTimeIgnored = echoMap.get("Ignore CTime", "")
    
        if not ipV4 or not isSnapShotSupport or not isCTimeIgnored:
            return  cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "parse.ndpm.service.configuration.failed")
        
        needsOptimizeOption = ""
        flag = True

        if ipV4 != "0.0.0.0":
            LOGGER.logNoPass("checking whether the ip setting is 0.0.0.0 failed.")
            flag = False
            needsOptimizeOption += common.getMsg(LANG, "show.service.ndmp.ip.not.pass", ipV4)
            
        if isSnapShotSupport.lower() != "yes":
            LOGGER.logNoPass("checking whether the snapshot switch is on failed.")
            flag = False
            needsOptimizeOption += common.getMsg(LANG, "show.service.ndmp.isSnapShotSupport.not.pass", isSnapShotSupport)
            
        if isCTimeIgnored.lower() != "no":
            LOGGER.logNoPass("checking whether the CTime ignore switch is off failed.")  
            flag = False  
            needsOptimizeOption += common.getMsg(LANG, "show.service.ndmp.isCTimeIgnored.not.pass", isCTimeIgnored)

        if not flag :
            return cliUtil.RESULT_WARNING, cliRet, needsOptimizeOption
        else :
            LOGGER.logPass()    
            return flag, cliRet, errMsg

        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def isCmdExecutedWithError(cmdEcho):
    '''
    @summary: check whether the command has executed failed
    @return:  True or False
    '''
    if not cmdEcho:
        return False
    for cmdLine in cmdEcho.splitlines():
        if ("error:" in cmdLine.lower() or "error :" in cmdLine.lower()) and "license" not in cmdLine.lower():
            return True
        
    return False