# -*- coding: UTF-8 -*-
import traceback
import cliUtil
import common
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
          容量层冗余级别检查
    1、若存储池不存在，检查结果为通过。
    2、若步骤3查询结果中Name为Capacity且RAID Level 不为RAID6，检查结果为不通过。
    3、其他情况检查结果为通过。
    '''  
    flag = True
    cliRet = ""
    allCliRet = ""
    errMsg = ""
    #发货版本
    VERSION = "V300R003C20SPC200"
    try:
        #获取设备当前产品版本
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        allCliRet = common.joinLines(allCliRet, checkRet[1])
        if checkRet[0] != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        #只检查V300R003C20SPC200及之后版本（发货版本）
        if currentVersion < VERSION:
            return (True, allCliRet, errMsg)
        cmd = "show storage_pool general"
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True: 
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, allCliRet, errMsg)
        
        poolInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(poolInfoDictList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.pool.info")
            LOGGER.logNoPass("Cannot get information about POOL")
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
        
        poolIdList = []
        for poolInfoDict in poolInfoDictList:
            poolId = poolInfoDict.get("ID", "")
            if poolId:
                poolIdList.append(poolId)
        
        flag, cliRet, errMsg = checkSasRaidLevel(cli, poolIdList)
        allCliRet = common.joinLines(allCliRet, cliRet)
            
        return (flag, allCliRet, errMsg)
            
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))


def checkSasRaidLevel(cli, poolIdList):
    '''
    @summary: 检查存储池冗余级别是否正常
    @param poolIdList: 存储池ID列表
    @param cli: cli对象
    '''
    flag = True
    errMsg = ""
    allCliRet = ""
    riskIDList = []
    for poolId in poolIdList:
        cmd = "show storage_pool tier pool_id=%s" % poolId
        result, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if result != True:
            return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
            
        infoDictList = cliUtil.getVerticalCliRet(cliRet)
        for infoDict in infoDictList:
            name = infoDict.get("Name", "")
            raidLevel = infoDict.get("RAID Level", "")
            if (not name) or (not raidLevel):
                errMsg = common.getMsg(LANG, "query.result.abnormal")
                return (cliUtil.RESULT_NOCHECK, allCliRet, errMsg)
                 
            if  name == "Capacity" and raidLevel != "RAID6":
                flag = False
                riskIDList.append(poolId)
    
    if riskIDList:
        errMsg += common.getMsg(LANG, "raid.level.config.error", ",".join(riskIDList))
    
    return (flag, allCliRet, errMsg)            
        
        