# -*- coding:utf-8 -*-
import re
import traceback

import cliUtil
import common
from common import UnCheckException
from common_utils import get_err_msg

from cbb.business.checkitems.nic_bond_mode_check import (
    CheckNicBondMode,
)

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

RISK_VERSION = re.compile("6.0.1.*")
SAFETY_HOT_PATCH = 6


def execute(cli):
    """
    高端环境绑定端口检查.
    :param cli:
    :return:
    """
    nic_bond_mode_check_object = CheckNicBondMode(
        cli, LANG, PY_JAVA_ENV, LOGGER
    )
    try:
        error_message = ""
        flag = nic_bond_mode_check_object.execute_check()
        if not flag:
            error_message = get_err_msg(
                LANG, "nic.bond.mode.sph6.error_message"
            )
        return (
            flag,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            error_message,
        )

    except UnCheckException as e:
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            e.errorMsg,
        )
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(nic_bond_mode_check_object.all_ret_list),
            common.getMsg(LANG, "query.result.abnormal"),
        )
