# coding: UTF-8

from com.huawei.ism.exception import IsmException

import cliUtil
import common
from frameone.util import contextUtil
from frameone.rest import restData
from frameone.rest import restUtil
from common import UnCheckException
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

##磁盘利用率的最大值和平均值的阈值定义
allCliRet = ""
ISCSI_TYPE = 222
FC_TYPE = 223
IB_TYPE = 16499
RISK_HOST_OPERITION_SYSTEM = ['Solaris', 'Linux','VMware ESX', 'Windows']
REST_CAN_NOT_CONNECT_CODE = "1073949185"


def execute(cli):
    global allCliRet
    try:
        errPathNum = ""
        
        cmd = "show host general"
        flag, cli_ret, err_msg = execute_cmd_in_cli_mode_with_cache(
            py_java_env, cli, cmd, LOGGER)
        allCliRet = common.joinLines(allCliRet, cli_ret)
        if flag is not True:
            LOGGER.logInfo("Failed to get host:%s" % err_msg)
            raise common.UnCheckException(common.getMsg(LANG, "cannot.get.info", {"zh": u"主机", "en": "host"}.get(LANG)),
                                          allCliRet)

        hostDictList = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        hostIdList = []
        for tmpHostDict in hostDictList:
            hostId = tmpHostDict.get("ID", '')
            operName = tmpHostDict.get("Operating System", '')
            if operName and operName not in RISK_HOST_OPERITION_SYSTEM:
                continue
            
            hostIdList.append(hostId)
            
        LOGGER.logInfo("hostIdList :%s" % hostIdList)
        if not hostIdList:
            return True, allCliRet, ''
        
        dataDict = contextUtil.getContext(py_java_env)
        uriParamDict = {"paramList": []}
        cmdStr = "host_link?INITIATOR_TYPE=%s&PARENTID=%s"
        restCmdType = restData.RestCfg.RestMethod.GET
        initiatorTypeList = [ISCSI_TYPE, FC_TYPE, IB_TYPE]

        hostPathDict = {}
        rest = contextUtil.getRest(dataDict)
        for hostId in hostIdList:
            ctrlPathDict = {}
            for iniType in initiatorTypeList:
                tmpCmdStr = cmdStr % (iniType, hostId)
                uriParamDict["objUri"] = tmpCmdStr
                records = []
                try:
                    allCliRet = common.joinLines(allCliRet, rest.getBaseUri() + tmpCmdStr)
                    records = restUtil.CommonRestService.get4Big(rest, tmpCmdStr)
                    LOGGER.logInfo("records :%s" % records)
                except IsmException, ismException:
                    LOGGER.logError(u"ismException :%s" % unicode(ismException.toString()))
                    if iniType != IB_TYPE:
                        try:
                            rest.close()
                            LOGGER.logInfo("conn close success, close session in except 0!")
                        except Exception, e:
                            LOGGER.logError("conn close except 0: %s" % str(e))
                        raise UnCheckException(common.getMsg(LANG, "cannot.build.http.connections"), allCliRet)
                except Exception, exception:
                    if exception.args[0] == REST_CAN_NOT_CONNECT_CODE:
                        try:
                            rest.close()
                            LOGGER.logInfo("conn close success, close session in except!")
                        except Exception, e:
                            LOGGER.logError("conn close except 1: %s" % str(e))
                        errMsg = common.getMsg(LANG, "cannot.build.http.connections")
                        return cliUtil.RESULT_NOCHECK, allCliRet, errMsg
                    LOGGER.logException(exception)
                    
                allCliRet = common.joinLines(allCliRet, str(records))
                LOGGER.logInfo("records :%s" % records)
                for record in records:
                    ctrlId = record.get("CTRL_ID", '')
                    targetWwn = record.get("TARGET_PORT_WWN", '')
                    initWwn = record.get("INITIATOR_PORT_WWN", '')
                    tmpCtrlPathDict = ctrlPathDict.get(ctrlId, {})
                    pathNum = tmpCtrlPathDict.get("pathNum", 0)
                    pathWwnList = tmpCtrlPathDict.get("wwnList", [])
                    if targetWwn and initWwn and (targetWwn, initWwn) not in pathWwnList:
                        pathWwnList.append((targetWwn, initWwn))
                        pathNum += 1
                    tmpCtrlPathDict["pathNum"] = pathNum
                    tmpCtrlPathDict["wwnList"] = pathWwnList
                    ctrlPathDict[ctrlId] = tmpCtrlPathDict
            hostPathDict[hostId] = ctrlPathDict
        
        try:
            rest.close()
            LOGGER.logInfo("conn close success, close session!")
        except Exception, e:
            LOGGER.logError("conn close except: %s" % str(e))
        
        LOGGER.logInfo("hostPathDict:%s" % hostPathDict)
        for hostId in hostPathDict:
            ctrlDict = hostPathDict.get(hostId, {})
            ctrlList = ctrlDict.keys()
            for ctrlId in ctrlList:
                pathNum = ctrlDict.get(ctrlId, {}).get("pathNum", 0)
                if pathNum > 8:
                    errPathNum += common.getMsg(LANG, "check.utrapath.path.num.not.pass", (hostId, ctrlId, pathNum))

        if errPathNum:
            return False, allCliRet, errPathNum

        return True, allCliRet, ''
    
    except UnCheckException, unCheckException:
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, allCliRet, unCheckException.errorMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
