# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''


def execute(cli):
    '''
    BBU版本检查: 
                所有BBU的Firmware Version均存在且一致表示正常，其它情况均属于不正常状态。
    '''
    global ALL_CLI_RET
    errMsg = ''
    cliRet = ''
    flag = True
    try:
        upFlag = isUpgrading(cli)
        LOGGER.logInfo("isUpgrading:%s" % upFlag)
        if upFlag:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG,
                                                                      "firmware.version.of.bbu.inconsistent.upgrading")

        # 退出到正常admin模式。
        cliUtil.enterCliModeFromSomeModel(cli, LANG)

        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet

        bbuRet = cliUtil.getSplitedCliRet(cliRet, "BBU:")
        cliRetLinesList = cliUtil.getHorizontalCliRet(bbuRet)

        if len(bbuRet) == 0 or len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.firmware.version.info")
            LOGGER.logNoPass("Cannot get information about Firmware Version of BBU")
            return (False, cliRet, errMsg)

        bbuVersionSet = set()
        for line in cliRetLinesList:
            bbuId = line.get("ID", '')
            bbuVersion = line.get("Firmware Version")
            if len(bbuVersion) > 0 and bbuVersion != "--":
                bbuVersionSet.add(bbuVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.firmware.version.of.bbu", bbuId)
                LOGGER.logNoPass("Cannot get information about Firmware Version of BBU [%s]" % bbuId)

        if len(bbuVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "firmware.version.of.bbu.inconsistent", ", ".join(bbuVersionSet))
            LOGGER.logNoPass("The firmware versions of all BBUs are inconsistent")

        if flag:
            LOGGER.logPass()

        return (flag, ALL_CLI_RET, errMsg)

    except common.UnCheckException, unCheckException:
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        cliUtil.enterCliModeFromSomeModel(cli, LANG)


def isUpgrading(cli):
    """
    判断是否是升级状态
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    # V300R002C20 之前的版本不支持该命令
    productVersion = str(py_java_env.get("devInfo").getProductVersion())
    if productVersion < 'V300R002C20':
        LOGGER.logInfo("product version is:%s, not support check upgrading." % productVersion)
        return False

    # 进入developer
    flag, cliRet, errMsg = cliUtil.enterDeveloperMode(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, cliUtil.RESULT_NOCHECK)

    cmd = "show upgrade backgroundtask"
    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloper(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise common.UnCheckException(errMsg, cliUtil.RESULT_NOCHECK)

    cliRetLinesList = cliRet.splitlines()
    LOGGER.logInfo("product version is:%s, cliRetLinesList:%s." % (productVersion, str(cliRetLinesList)))
    for line in cliRetLinesList:
        if "Upgrading" in line:
            return True

    return False
