# -*- coding: UTF-8 -*-
from memory_inspect.check_item.timed_check_item_base import TimedLogBaseCheckItem
from memory_inspect.parser.message_dq_parser import MessageParser
from memory_inspect.rule.sys_disk_rule import CtrlSysDiskRule
from memory_inspect.utils.constants import CheckResult

ITEM_ID = "SysDiskCheck"


def execute(cli):
    return SysDiskCheck(py_java_env, PY_LOGGER, cli).execute()


class SysDiskCheck(TimedLogBaseCheckItem):
    def do_check(self):
        self.parse_log_files()
        return self.run_rules()

    def parse_log_files(self):
        collected_files = self.context.get("collected_files") or {}
        parser = MessageParser(self.logger)
        for ctrl, one_ctrl_files in collected_files.items():
            self._update_last_err_time(ctrl)
            message_files = one_ctrl_files.get("messages", [])
            sys_disk_infos = parser.parse_err_disk_info(message_files)
            filter_data = []
            for disk_info in sys_disk_infos:
                if disk_info.get("time") <= self.last_err_time:
                    continue
                disk_info.update({"sn": self.sn, "ctrl": ctrl, "obj_id": ctrl, "item_id": ITEM_ID})
                filter_data.append(disk_info)
            if filter_data:
                self.db_service.log_err_tbl.save_log_error_data(filter_data)

    def run_rules(self):
        rule_obj = CtrlSysDiskRule(self._get_rule_context())
        status = rule_obj.execute()
        origin_info = rule_obj.origin_info
        if status:
            return CheckResult.NOT_PASS, origin_info, "\n".join(rule_obj.err_msg)
        return CheckResult.PASS, origin_info, ""

    def _update_last_err_time(self, ctrl):
        last_err_time = self.db_service.log_err_tbl.get_latest_err_time_from_db(self.sn, ctrl, ITEM_ID)
        if last_err_time:
            self.last_err_time = last_err_time
